/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.MacConfig;
import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.MacPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.ThreadUtils;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class GenerateDmg
extends ArtifactGenerator<MacPackager> {
    public GenerateDmg() {
        super("DMG image");
    }

    @Override
    public boolean skip(MacPackager packager) {
        if (!packager.getMacConfig().isGenerateDmg()) {
            return true;
        }
        if (!packager.getPlatform().isCurrentPlatform()) {
            Logger.warn(this.getArtifactName() + " cannot be generated due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(MacPackager packager) throws Exception {
        File appFolder = packager.getAppFolder();
        File assetsFolder = packager.getAssetsFolder();
        String name = packager.getName();
        File outputDirectory = packager.getOutputDirectory();
        File iconFile = packager.getIconFile();
        String version = packager.getVersion();
        MacConfig macConfig = packager.getMacConfig();
        String volumeName = (String)StringUtils.defaultIfBlank((CharSequence)macConfig.getVolumeName(), (CharSequence)name);
        if (StringUtils.containsWhitespace((CharSequence)volumeName)) {
            volumeName = volumeName.replaceAll(" ", "");
            Logger.warn("Whitespaces has been removed from volume name: " + volumeName);
        }
        File dmgFile = new File(outputDirectory, name + "_" + version + ".dmg");
        File tempDmgFile = new File(assetsFolder, dmgFile.getName());
        File mountFolder = new File("/Volumes/" + volumeName);
        Logger.info("Copying background image");
        File backgroundFolder = FileUtils.mkdir(appFolder, ".background");
        File backgroundFile = new File(backgroundFolder, "background.png");
        if (macConfig.getBackgroundImage() != null) {
            FileUtils.copyFileToFile(macConfig.getBackgroundImage(), backgroundFile);
        } else {
            FileUtils.copyResourceToFile("/mac/background.png", backgroundFile);
        }
        Logger.info("Copying icon file: " + iconFile.getAbsolutePath());
        File volumeIcon = macConfig.getVolumeIcon() != null ? macConfig.getVolumeIcon() : iconFile;
        FileUtils.copyFileToFile(volumeIcon, new File(appFolder, ".VolumeIcon.icns"));
        Logger.info("Creating image: " + tempDmgFile.getAbsolutePath());
        CommandUtils.execute("hdiutil", "create", "-srcfolder", appFolder, "-volname", volumeName, "-ov", "-fs", "HFS+", "-format", "UDRW", tempDmgFile);
        if (mountFolder.exists()) {
            Logger.info("Unmounting volume: " + mountFolder);
            CommandUtils.execute("hdiutil", "detach", mountFolder);
        }
        Logger.info("Mounting image: " + tempDmgFile.getAbsolutePath());
        String result = CommandUtils.execute("hdiutil", "attach", "-readwrite", "-noverify", "-noautoopen", tempDmgFile);
        String deviceName = Arrays.asList(result.split("\n")).stream().filter(s -> s.contains(mountFolder.getAbsolutePath())).map(s -> StringUtils.normalizeSpace((String)s)).map(s -> s.split(" ")[0]).findFirst().get();
        Logger.info("- Device name: " + deviceName);
        ThreadUtils.sleep(2000L);
        Logger.info("Creating Applications link");
        File targetFolder = new File("/Applications");
        File linkFile = new File(mountFolder, "Applications");
        FileUtils.createSymlink(linkFile, targetFolder);
        Logger.info("Rendering DMG customization applescript ... ");
        File applescriptFile = new File(assetsFolder, "customize-dmg.applescript");
        VelocityUtils.render("/mac/customize-dmg.applescript.vtl", applescriptFile, packager);
        Logger.info("Applescript rendered in " + applescriptFile.getAbsolutePath() + "!");
        Logger.info("Running applescript");
        CommandUtils.execute("/usr/bin/osascript", applescriptFile, volumeName);
        Logger.info("Fixing permissions...");
        CommandUtils.execute("chmod", "-Rf", "u+r,go-w", mountFolder);
        Logger.info("Blessing ...");
        CommandUtils.execute("bless", "--folder", mountFolder, "--openfolder", mountFolder);
        CommandUtils.execute("SetFile", "-a", "C", mountFolder);
        Logger.info("Unmounting volume: " + mountFolder);
        CommandUtils.execute("hdiutil", "detach", mountFolder);
        Logger.info("Compressing disk image...");
        CommandUtils.execute("hdiutil", "convert", tempDmgFile, "-ov", "-format", "UDZO", "-imagekey", "zlib-level=9", "-o", dmgFile);
        tempDmgFile.delete();
        if (!dmgFile.exists()) {
            throw new Exception(this.getArtifactName() + " generation failed!");
        }
        return dmgFile;
    }
}

