/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LinuxPackager
extends Packager {
    private File desktopFile;
    private File mimeXmlFile = null;

    public LinuxPackager() {
        this.installerGenerators.addAll(Context.getContext().getInstallerGenerators(Platform.linux));
    }

    public File getDesktopFile() {
        return this.desktopFile;
    }

    public File getMimeXmlFile() {
        return this.mimeXmlFile;
    }

    @Override
    public void doInit() throws Exception {
        this.linuxConfig.setDefaults(this);
    }

    @Override
    protected void doCreateAppStructure() throws Exception {
        this.executableDestinationFolder = this.appFolder;
        this.jarFileDestinationFolder = this.appFolder;
        this.jreDestinationFolder = new File(this.appFolder, this.jreDirectoryName);
        this.resourcesDestinationFolder = this.appFolder;
    }

    @Override
    public File doCreateApp() throws Exception {
        Logger.infoIndent("Creating GNU/Linux executable ...");
        this.executable = new File(this.appFolder, this.name);
        if (this.classpath != null) {
            this.classpaths = Arrays.asList(this.classpath.split("[:;]"));
            if (!this.isUseResourcesAsWorkingDir()) {
                this.classpaths = this.classpaths.stream().map(cp -> new File((String)cp).isAbsolute() ? cp : "$SCRIPTPATH/" + cp).collect(Collectors.toList());
            }
            this.classpath = StringUtils.join((Iterable)this.classpaths, (String)":");
        }
        this.desktopFile = new File(this.assetsFolder, this.name + ".desktop");
        VelocityUtils.render("linux/desktop.vtl", this.desktopFile, this);
        Logger.info("Rendering desktop file to " + this.desktopFile.getAbsolutePath());
        if (this.isThereFileAssociations()) {
            this.mimeXmlFile = new File(this.assetsFolder, this.name + ".xml");
            VelocityUtils.render("linux/mime.xml.vtl", this.mimeXmlFile, this);
            Logger.info("Rendering mime.xml file to " + this.mimeXmlFile.getAbsolutePath());
        }
        File startupFile = new File(this.assetsFolder, "startup.sh");
        VelocityUtils.render("linux/startup.sh.vtl", startupFile, this);
        Logger.info("Startup script generated in " + startupFile.getAbsolutePath());
        if (this.getLinuxConfig().isWrapJar()) {
            FileUtils.concat(this.executable, startupFile, this.jarFile);
        } else {
            FileUtils.copyFileToFile(startupFile, this.executable);
            FileUtils.copyFileToFolder(this.jarFile, this.appFolder);
        }
        this.executable.setExecutable(true, false);
        Logger.infoUnindent("GNU/Linux executable created in " + this.executable.getAbsolutePath() + "!");
        return this.appFolder;
    }
}

