/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import io.github.fvarrui.javapackager.utils.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

public class MacPackager
extends Packager {
    private File appFile;
    private File contentsFolder;
    private File resourcesFolder;
    private File javaFolder;
    private File macOSFolder;

    public File getAppFile() {
        return this.appFile;
    }

    @Override
    public void doInit() throws Exception {
        this.macConfig.setDefaults(this);
        if (!this.isUseResourcesAsWorkingDir()) {
            this.useResourcesAsWorkingDir = true;
            Logger.warn("'useResourcesAsWorkingDir' property disabled on Mac OS (useResourcesAsWorkingDir is always true)");
        }
    }

    @Override
    protected void doCreateAppStructure() throws Exception {
        this.appFile = new File(this.appFolder, this.name + ".app");
        this.contentsFolder = new File(this.appFile, "Contents");
        this.resourcesFolder = new File(this.contentsFolder, "Resources");
        this.javaFolder = new File(this.resourcesFolder, this.macConfig.isRelocateJar() ? "Java" : "");
        this.macOSFolder = new File(this.contentsFolder, "MacOS");
        FileUtils.mkdir(this.appFile);
        Logger.info("App file folder created: " + this.appFile.getAbsolutePath());
        FileUtils.mkdir(this.contentsFolder);
        Logger.info("Contents folder created: " + this.contentsFolder.getAbsolutePath());
        FileUtils.mkdir(this.resourcesFolder);
        Logger.info("Resources folder created: " + this.resourcesFolder.getAbsolutePath());
        FileUtils.mkdir(this.javaFolder);
        Logger.info("Java folder created: " + this.javaFolder.getAbsolutePath());
        FileUtils.mkdir(this.macOSFolder);
        Logger.info("MacOS folder created: " + this.macOSFolder.getAbsolutePath());
        this.executableDestinationFolder = this.macOSFolder;
        this.jarFileDestinationFolder = this.javaFolder;
        this.jreDestinationFolder = new File(this.contentsFolder, "PlugIns/" + this.jreDirectoryName + "/Contents/Home");
        this.resourcesDestinationFolder = this.resourcesFolder;
    }

    @Override
    public File doCreateApp() throws Exception {
        FileUtils.copyFileToFolder(this.jarFile, this.javaFolder);
        if (this.administratorRequired.booleanValue()) {
            this.executable = new File(this.macOSFolder, "startup");
            VelocityUtils.render("mac/startup.vtl", this.executable, this);
            this.executable.setExecutable(true, false);
            Logger.info("Startup script file created in " + this.executable.getAbsolutePath());
        } else {
            this.executable = new File(this.macOSFolder, "universalJavaApplicationStub");
            Logger.info("Using " + this.executable.getAbsolutePath() + " as startup script");
        }
        File appStubFile = new File(this.macOSFolder, "universalJavaApplicationStub");
        FileUtils.copyResourceToFile("/mac/universalJavaApplicationStub", appStubFile, true);
        FileUtils.processFileContent(appStubFile, content -> {
            if (!this.macConfig.isRelocateJar()) {
                content = content.replaceAll("/Contents/Resources/Java", "/Contents/Resources");
            }
            content = content.replaceAll("\\$\\{info.name\\}", this.name);
            return content;
        });
        appStubFile.setExecutable(true, false);
        this.classpath = (this.macConfig.isRelocateJar() ? "Java/" : "") + this.jarFile.getName() + (this.classpath != null ? ":" + this.classpath : "");
        this.classpaths = Arrays.asList(this.classpath.split("[:;]"));
        if (!this.isUseResourcesAsWorkingDir()) {
            this.classpaths = this.classpaths.stream().map(cp -> new File((String)cp).isAbsolute() ? cp : "$ResourcesFolder/" + cp).collect(Collectors.toList());
        }
        this.classpath = StringUtils.join((Iterable)this.classpaths, (String)":");
        File infoPlistFile = new File(this.contentsFolder, "Info.plist");
        VelocityUtils.render("mac/Info.plist.vtl", infoPlistFile, this);
        XMLUtils.prettify(infoPlistFile);
        Logger.info("Info.plist file created in " + infoPlistFile.getAbsolutePath());
        if (!Platform.mac.isCurrentPlatform()) {
            Logger.warn("Generated app could not be signed due to current platform is " + (Object)((Object)Platform.getCurrentPlatform()));
        } else if (!this.getMacConfig().isCodesignApp()) {
            Logger.warn("App codesigning disabled");
        } else {
            this.codesign(this.macConfig.getDeveloperId(), this.macConfig.getEntitlements(), this.appFile);
        }
        return this.appFile;
    }

    private void codesign(String developerId, File entitlements, File appFile) throws IOException, CommandLineException {
        ArrayList<Object> codesignArgs = new ArrayList<Object>();
        codesignArgs.add("--force");
        codesignArgs.add("--deep");
        if (entitlements == null) {
            Logger.warn("Entitlements file not specified");
        } else if (!entitlements.exists()) {
            Logger.warn("Entitlements file doesn't exist: " + entitlements);
        } else {
            codesignArgs.add("--entitlements");
            codesignArgs.add(entitlements);
        }
        codesignArgs.add("--sign");
        codesignArgs.add(developerId);
        codesignArgs.add(appFile);
        CommandUtils.execute("codesign", codesignArgs.toArray(new Object[codesignArgs.size()]));
    }
}

