/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.BundleJre;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.PackagerSettings;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.IconUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class Packager
extends PackagerSettings {
    private static final String DEFAULT_ORGANIZATION_NAME = "ACME";
    protected List<ArtifactGenerator<?>> installerGenerators = new ArrayList();
    private BundleJre generateJre = new BundleJre();
    protected File appFolder;
    protected File assetsFolder;
    protected File executable;
    protected File jarFile;
    protected File libsFolder;
    protected File bootstrapFile;
    protected File executableDestinationFolder;
    protected File jarFileDestinationFolder;
    protected File jreDestinationFolder;
    protected File resourcesDestinationFolder;
    protected List<String> classpaths = new ArrayList<String>();

    public File getAppFolder() {
        return this.appFolder;
    }

    public File getAssetsFolder() {
        return this.assetsFolder;
    }

    public File getExecutable() {
        return this.executable;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getJarFileDestinationFolder() {
        return this.jarFileDestinationFolder;
    }

    public File getLibsFolder() {
        return this.libsFolder;
    }

    public List<String> getClasspaths() {
        return this.classpaths;
    }

    public File getJreDestinationFolder() {
        return this.jreDestinationFolder;
    }

    public File getBootstrapFile() {
        return this.bootstrapFile;
    }

    public Packager() {
        Logger.info("Using packager " + this.getClass().getName());
    }

    private void init() throws Exception {
        Logger.infoIndent("Initializing packager ...");
        if (this.mainClass == null || this.mainClass.isEmpty()) {
            throw new Exception("'mainClass' cannot be null");
        }
        VelocityUtils.setAssetsDir(this.assetsDir);
        this.displayName = (String)StringUtils.defaultIfBlank((CharSequence)this.displayName, (CharSequence)this.name);
        this.description = (String)StringUtils.defaultIfBlank((CharSequence)this.description, (CharSequence)this.displayName);
        this.organizationName = (String)StringUtils.defaultIfBlank((CharSequence)this.organizationName, (CharSequence)DEFAULT_ORGANIZATION_NAME);
        this.organizationUrl = (String)StringUtils.defaultIfBlank((CharSequence)this.organizationUrl, (CharSequence)"");
        if (this.platform == null || this.platform == Platform.auto) {
            this.platform = Platform.getCurrentPlatform();
        }
        if (this.jdkPath == null) {
            this.jdkPath = new File(System.getProperty("java.home"));
        }
        if (!this.jdkPath.exists()) {
            throw new Exception("JDK path doesn't exist: " + this.jdkPath);
        }
        try {
            Paths.get(this.name, new String[0]);
            if (this.name.contains("/")) {
                throw new InvalidPathException(this.name, "Illegal char </>");
            }
            if (this.name.contains("\\")) {
                throw new InvalidPathException(this.name, "Illegal char <\\>");
            }
        }
        catch (InvalidPathException e) {
            throw new Exception("Invalid name specified: " + this.name, e);
        }
        if (this.platform.equals((Object)Platform.windows) && (this.winConfig.getSetupLanguages() == null || this.winConfig.getSetupLanguages().isEmpty())) {
            this.winConfig.getSetupLanguages().put("english", "compiler:Default.isl");
            this.winConfig.getSetupLanguages().put("spanish", "compiler:Languages\\Spanish.isl");
        }
        this.doInit();
        switch (this.platform) {
            case linux: {
                this.macConfig = null;
                this.winConfig = null;
                break;
            }
            case mac: {
                this.winConfig = null;
                this.linuxConfig = null;
                break;
            }
            case windows: {
                this.linuxConfig = null;
                this.macConfig = null;
                break;
            }
        }
        Logger.info("" + this);
        Logger.infoUnindent("Packager initialized!");
    }

    public void resolveResources() throws Exception {
        Logger.infoIndent("Resolving resources ...");
        this.licenseFile = this.resolveLicense(this.licenseFile);
        this.iconFile = this.resolveIcon(this.iconFile, this.name, this.assetsFolder);
        if (this.additionalResources != null) {
            if (this.licenseFile != null) {
                this.additionalResources.add(this.licenseFile);
            }
            this.additionalResources.add(this.iconFile);
            Logger.info("Effective additional resources " + this.additionalResources);
        }
        Logger.infoUnindent("Resources resolved!");
    }

    protected void copyAdditionalResources(List<File> resources, File destination) {
        Logger.infoIndent("Copying additional resources");
        resources.stream().forEach(r -> {
            if (!r.exists()) {
                Logger.warn("Additional resource " + r + " doesn't exist");
                return;
            }
            try {
                if (r.isDirectory()) {
                    FileUtils.copyFolderToFolder(r, destination);
                } else if (r.isFile()) {
                    FileUtils.copyFileToFolder(r, destination);
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        });
        if (FileUtils.exists(this.getScripts().getBootstrap())) {
            String scriptExtension = FilenameUtils.getExtension((String)this.getScripts().getBootstrap().getName());
            File scriptsFolder = new File(destination, "scripts");
            this.bootstrapFile = new File(scriptsFolder, "bootstrap" + (!scriptExtension.isEmpty() ? "." + scriptExtension : ""));
            try {
                FileUtils.copyFileToFile(this.getScripts().getBootstrap(), this.bootstrapFile);
                this.bootstrapFile.setExecutable(true, false);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), e);
            }
        }
        Logger.infoUnindent("All additional resources copied!");
    }

    protected File resolveLicense(File licenseFile) {
        if (licenseFile != null && !licenseFile.exists()) {
            Logger.warn("Specified license file doesn't exist: " + licenseFile.getAbsolutePath());
            licenseFile = null;
        }
        if (licenseFile == null) {
            try {
                licenseFile = Context.getContext().resolveLicense(this);
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
            }
        }
        if (!(licenseFile != null && licenseFile.exists() || (licenseFile = new File(Context.getContext().getRootDir(), "LICENSE")).exists())) {
            licenseFile = null;
        }
        if (licenseFile != null) {
            Logger.info("License file found: " + licenseFile.getAbsolutePath());
        } else {
            Logger.warn("No license file specified");
        }
        return licenseFile;
    }

    protected File resolveIcon(File iconFile, String name, File assetsFolder) throws Exception {
        switch (this.platform) {
            case linux: {
                iconFile = FileUtils.exists(this.linuxConfig.getPngFile()) ? this.linuxConfig.getPngFile() : null;
                break;
            }
            case mac: {
                iconFile = FileUtils.exists(this.macConfig.getIcnsFile()) ? this.macConfig.getIcnsFile() : null;
                break;
            }
            case windows: {
                iconFile = FileUtils.exists(this.winConfig.getIcoFile()) ? this.winConfig.getIcoFile() : null;
                break;
            }
        }
        String iconExtension = IconUtils.getIconFileExtensionByPlatform(this.platform);
        if (iconFile == null) {
            iconFile = new File(this.assetsDir, (Object)((Object)this.platform) + "/" + name + iconExtension);
        }
        if (!iconFile.exists()) {
            iconFile = new File(assetsFolder, iconFile.getName());
            FileUtils.copyResourceToFile("/" + (Object)((Object)this.platform) + "/default-icon" + iconExtension, iconFile);
        }
        Logger.info("Icon file resolved: " + iconFile.getAbsolutePath());
        return iconFile;
    }

    public List<File> createBundles() throws Exception {
        ArrayList<File> bundles = new ArrayList<File>();
        Logger.infoIndent("Creating bundles ...");
        if (this.createZipball.booleanValue()) {
            File zipball = Context.getContext().createZipball(this);
            Logger.info("Zipball created: " + zipball);
            bundles.add(zipball);
        }
        if (this.createTarball.booleanValue()) {
            File tarball = Context.getContext().createTarball(this);
            Logger.info("Tarball created: " + tarball);
            bundles.add(tarball);
        }
        Logger.infoUnindent("Bundles created!");
        return bundles;
    }

    private void createAppStructure() throws Exception {
        Logger.infoIndent("Creating app structure ...");
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.appFolder = new File(this.outputDirectory, this.name);
        if (this.appFolder.exists()) {
            FileUtils.removeFolder(this.appFolder);
            Logger.info("Old app folder removed " + this.appFolder.getAbsolutePath());
        }
        this.appFolder = FileUtils.mkdir(this.outputDirectory, this.name);
        Logger.info("App folder created: " + this.appFolder.getAbsolutePath());
        this.assetsFolder = FileUtils.mkdir(this.outputDirectory, "assets");
        Logger.info("Assets folder created: " + this.assetsFolder.getAbsolutePath());
        this.doCreateAppStructure();
        Logger.infoUnindent("App structure created!");
    }

    public File createApp() throws Exception {
        Logger.infoIndent("Creating app ...");
        this.init();
        this.createAppStructure();
        this.resolveResources();
        this.copyAdditionalResources(this.additionalResources, this.resourcesDestinationFolder);
        Logger.infoIndent("Copying all dependencies ...");
        this.libsFolder = this.copyDependencies != false ? Context.getContext().copyDependencies(this) : null;
        Logger.infoUnindent("Dependencies copied to " + this.libsFolder + "!");
        if (this.runnableJar != null && this.runnableJar.exists()) {
            Logger.info("Using runnable JAR: " + this.runnableJar);
            this.jarFile = this.runnableJar;
        } else {
            Logger.infoIndent("Creating runnable JAR...");
            this.jarFile = Context.getContext().createRunnableJar(this);
            Logger.infoUnindent("Runnable jar created in " + this.jarFile + "!");
        }
        this.generateJre.apply(this);
        File appFile = this.doCreateApp();
        Logger.infoUnindent("App created in " + this.appFolder.getAbsolutePath() + "!");
        return appFile;
    }

    public List<File> generateInstallers() throws Exception {
        ArrayList<File> installers = new ArrayList<File>();
        if (!this.generateInstaller.booleanValue()) {
            Logger.warn("Installer generation is disabled by 'generateInstaller' property!");
            return installers;
        }
        Logger.infoIndent("Generating installers ...");
        this.init();
        this.assetsFolder = FileUtils.mkdir(this.outputDirectory, "assets");
        for (ArtifactGenerator<Packager> generator : Context.getContext().getInstallerGenerators(this.platform)) {
            try {
                Logger.infoIndent("Generating " + generator.getArtifactName() + "...");
                File artifact = generator.apply(this);
                if (artifact != null) {
                    CollectionUtils.addIgnoreNull(installers, (Object)artifact);
                    Logger.infoUnindent(generator.getArtifactName() + " generated in " + artifact + "!");
                    continue;
                }
                Logger.warnUnindent(generator.getArtifactName() + " NOT generated!!!");
            }
            catch (Exception e) {
                Logger.errorUnindent(generator.getArtifactName() + " generation failed due to: " + e.getMessage(), e);
            }
        }
        Logger.infoUnindent("Installers generated! " + installers);
        return installers;
    }

    protected abstract void doCreateAppStructure() throws Exception;

    public abstract File doCreateApp() throws Exception;

    public abstract void doInit() throws Exception;
}

