/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.FileAssociation;
import io.github.fvarrui.javapackager.model.LinuxConfig;
import io.github.fvarrui.javapackager.model.MacConfig;
import io.github.fvarrui.javapackager.model.Manifest;
import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.model.Scripts;
import io.github.fvarrui.javapackager.model.WindowsConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PackagerSettings {
    protected File outputDirectory;
    protected File licenseFile;
    protected File iconFile;
    protected Boolean generateInstaller;
    protected String mainClass;
    protected String name;
    protected String displayName;
    protected String version;
    protected String description;
    protected String url;
    protected Boolean administratorRequired;
    protected String organizationName;
    protected String organizationUrl;
    protected String organizationEmail;
    protected Boolean bundleJre;
    protected Boolean customizedJre;
    protected File jrePath;
    protected File jdkPath;
    protected List<File> additionalResources;
    protected List<String> modules;
    protected List<String> additionalModules;
    protected Platform platform;
    protected String envPath;
    protected List<String> vmArgs;
    protected File runnableJar;
    protected Boolean copyDependencies;
    protected String jreDirectoryName;
    protected WindowsConfig winConfig;
    protected LinuxConfig linuxConfig;
    protected MacConfig macConfig;
    protected Boolean createTarball;
    protected Boolean createZipball;
    protected Map<String, String> extra;
    protected boolean useResourcesAsWorkingDir;
    protected File assetsDir;
    protected String classpath;
    protected String jreMinVersion;
    protected Manifest manifest;
    protected List<File> additionalModulePaths;
    protected List<FileAssociation> fileAssociations;
    protected File packagingJdk;
    protected Scripts scripts;

    public File getPackagingJdk() {
        return this.packagingJdk;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public File getIconFile() {
        return this.iconFile;
    }

    public Boolean getGenerateInstaller() {
        return this.generateInstaller;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getAdministratorRequired() {
        return this.administratorRequired;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public String getOrganizationEmail() {
        return this.organizationEmail;
    }

    public Boolean getBundleJre() {
        return this.bundleJre;
    }

    public Boolean getCustomizedJre() {
        return this.customizedJre;
    }

    public File getJrePath() {
        return this.jrePath;
    }

    public File getJdkPath() {
        return this.jdkPath;
    }

    public List<File> getAdditionalResources() {
        return this.additionalResources;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public List<String> getAdditionalModules() {
        return this.additionalModules;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getEnvPath() {
        return this.envPath;
    }

    public List<String> getVmArgs() {
        return this.vmArgs;
    }

    public File getRunnableJar() {
        return this.runnableJar;
    }

    public Boolean getCopyDependencies() {
        return this.copyDependencies;
    }

    public String getJreDirectoryName() {
        return this.jreDirectoryName;
    }

    public WindowsConfig getWinConfig() {
        return this.winConfig;
    }

    public LinuxConfig getLinuxConfig() {
        return this.linuxConfig;
    }

    public MacConfig getMacConfig() {
        return this.macConfig;
    }

    public Boolean getCreateTarball() {
        return this.createTarball;
    }

    public Boolean getCreateZipball() {
        return this.createZipball;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public boolean isUseResourcesAsWorkingDir() {
        return this.useResourcesAsWorkingDir;
    }

    public File getAssetsDir() {
        return this.assetsDir;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getJreMinVersion() {
        return this.jreMinVersion;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public List<File> getAdditionalModulePaths() {
        return this.additionalModulePaths;
    }

    public List<FileAssociation> getFileAssociations() {
        return this.fileAssociations;
    }

    public Scripts getScripts() {
        return this.scripts;
    }

    public PackagerSettings outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public PackagerSettings packagingJdk(File packagingJdk) {
        this.packagingJdk = packagingJdk;
        return this;
    }

    public PackagerSettings licenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
        return this;
    }

    public PackagerSettings iconFile(File iconFile) {
        this.iconFile = iconFile;
        return this;
    }

    public PackagerSettings generateInstaller(Boolean generateInstaller) {
        this.generateInstaller = generateInstaller;
        return this;
    }

    public PackagerSettings mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public PackagerSettings name(String name) {
        this.name = name;
        return this;
    }

    public PackagerSettings displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public PackagerSettings version(String version) {
        this.version = version;
        return this;
    }

    public PackagerSettings description(String description) {
        this.description = description;
        return this;
    }

    public PackagerSettings url(String url) {
        this.url = url;
        return this;
    }

    public PackagerSettings administratorRequired(Boolean administratorRequired) {
        this.administratorRequired = administratorRequired;
        return this;
    }

    public PackagerSettings organizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public PackagerSettings organizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
        return this;
    }

    public PackagerSettings organizationEmail(String organizationEmail) {
        this.organizationEmail = organizationEmail;
        return this;
    }

    public PackagerSettings bundleJre(Boolean bundleJre) {
        this.bundleJre = bundleJre;
        return this;
    }

    public PackagerSettings customizedJre(Boolean customizedJre) {
        this.customizedJre = customizedJre;
        return this;
    }

    public PackagerSettings jrePath(File jrePath) {
        this.jrePath = jrePath;
        return this;
    }

    public PackagerSettings jdkPath(File jdkPath) {
        this.jdkPath = jdkPath;
        return this;
    }

    public PackagerSettings additionalResources(List<File> additionalResources) {
        this.additionalResources = new ArrayList<File>(additionalResources);
        return this;
    }

    public PackagerSettings modules(List<String> modules) {
        this.modules = new ArrayList<String>(modules);
        return this;
    }

    public PackagerSettings additionalModules(List<String> additionalModules) {
        this.additionalModules = new ArrayList<String>(additionalModules);
        return this;
    }

    public PackagerSettings platform(Platform platform) {
        this.platform = platform;
        return this;
    }

    public PackagerSettings envPath(String envPath) {
        this.envPath = envPath;
        return this;
    }

    public PackagerSettings vmArgs(List<String> vmArgs) {
        this.vmArgs = new ArrayList<String>(vmArgs);
        return this;
    }

    public PackagerSettings runnableJar(File runnableJar) {
        this.runnableJar = runnableJar;
        return this;
    }

    public PackagerSettings copyDependencies(Boolean copyDependencies) {
        this.copyDependencies = copyDependencies;
        return this;
    }

    public PackagerSettings jreDirectoryName(String jreDirectoryName) {
        this.jreDirectoryName = jreDirectoryName;
        return this;
    }

    public PackagerSettings winConfig(WindowsConfig winConfig) {
        this.winConfig = winConfig;
        return this;
    }

    public PackagerSettings linuxConfig(LinuxConfig linuxConfig) {
        this.linuxConfig = linuxConfig;
        return this;
    }

    public PackagerSettings macConfig(MacConfig macConfig) {
        this.macConfig = macConfig;
        return this;
    }

    public PackagerSettings createTarball(Boolean createTarball) {
        this.createTarball = createTarball;
        return this;
    }

    public PackagerSettings createZipball(Boolean createZipball) {
        this.createZipball = createZipball;
        return this;
    }

    public PackagerSettings extra(Map<String, String> extra) {
        this.extra = extra;
        return this;
    }

    public PackagerSettings useResourcesAsWorkingDir(boolean useResourcesAsWorkingDir) {
        this.useResourcesAsWorkingDir = useResourcesAsWorkingDir;
        return this;
    }

    public PackagerSettings assetsDir(File assetsDir) {
        this.assetsDir = assetsDir;
        return this;
    }

    public PackagerSettings classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public PackagerSettings jreMinVersion(String jreMinVersion) {
        this.jreMinVersion = jreMinVersion;
        return this;
    }

    public PackagerSettings manifest(Manifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public PackagerSettings additionalModulePaths(List<File> additionalModulePaths) {
        this.additionalModulePaths = additionalModulePaths;
        return this;
    }

    public PackagerSettings fileAssociations(List<FileAssociation> fileAssociations) {
        this.fileAssociations = fileAssociations;
        return this;
    }

    public PackagerSettings scripts(Scripts scripts) {
        this.scripts = scripts;
        return this;
    }

    public boolean isThereFileAssociations() {
        return this.fileAssociations != null && !this.fileAssociations.isEmpty();
    }

    public String getMimeTypesListAsString(String separator) {
        return StringUtils.join((Iterable)this.fileAssociations.stream().map(fa -> fa.getMimeType()).collect(Collectors.toList()), (String)separator);
    }

    public String toString() {
        return "PackagerSettings [outputDirectory=" + this.outputDirectory + ", licenseFile=" + this.licenseFile + ", iconFile=" + this.iconFile + ", generateInstaller=" + this.generateInstaller + ", mainClass=" + this.mainClass + ", name=" + this.name + ", displayName=" + this.displayName + ", version=" + this.version + ", description=" + this.description + ", url=" + this.url + ", administratorRequired=" + this.administratorRequired + ", organizationName=" + this.organizationName + ", organizationUrl=" + this.organizationUrl + ", organizationEmail=" + this.organizationEmail + ", bundleJre=" + this.bundleJre + ", customizedJre=" + this.customizedJre + ", jrePath=" + this.jrePath + ", jdkPath=" + this.jdkPath + ", additionalResources=" + this.additionalResources + ", modules=" + this.modules + ", additionalModules=" + this.additionalModules + ", platform=" + (Object)((Object)this.platform) + ", envPath=" + this.envPath + ", vmArgs=" + this.vmArgs + ", runnableJar=" + this.runnableJar + ", copyDependencies=" + this.copyDependencies + ", jreDirectoryName=" + this.jreDirectoryName + ", winConfig=" + this.winConfig + ", linuxConfig=" + this.linuxConfig + ", macConfig=" + this.macConfig + ", createTarball=" + this.createTarball + ", createZipball=" + this.createZipball + ", extra=" + this.extra + ", useResourcesAsWorkingDir=" + this.useResourcesAsWorkingDir + ", assetsDir=" + this.assetsDir + ", classpath=" + this.classpath + ", jreMinVersion=" + this.jreMinVersion + ", manifest=" + this.manifest + ", additionalModulePaths=" + this.additionalModulePaths + ", fileAssociations=" + this.fileAssociations + ", packagingJdk=" + this.packagingJdk + ", scripts=" + this.scripts + "]";
    }
}

