/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.DatabaseQuery;
import cn.smallbun.screw.core.query.DatabaseType;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import cn.smallbun.screw.core.util.StringUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public abstract class AbstractDatabaseQuery
implements DatabaseQuery {
    protected final Map<String, List<Column>> columnsCaching = new ConcurrentHashMap<String, List<Column>>();
    private final DataSource dataSource;
    protected volatile Connection connection;

    public AbstractDatabaseQuery(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws QueryException {
        try {
            if (!Objects.isNull(this.connection) && !this.connection.isClosed()) {
                System.out.println(this.connection);
                return this.connection;
            }
            Class<AbstractDatabaseQuery> clazz = AbstractDatabaseQuery.class;
            synchronized (AbstractDatabaseQuery.class) {
                if (Objects.isNull(this.connection) || this.connection.isClosed()) {
                    this.connection = this.getDataSource().getConnection();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.connection;
            }
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    protected String getCatalog() throws QueryException {
        try {
            String catalog = this.getConnection().getCatalog();
            if (StringUtils.isBlank(catalog)) {
                return null;
            }
            return catalog;
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    protected String getSchema() throws QueryException {
        try {
            String url = this.getConnection().getMetaData().getURL();
            String name = JdbcUtils.getDbType(url).getName();
            String schema = DatabaseType.CACHEDB.getName().equals(name) ? this.verifySchema(this.getDataSource()) : this.getConnection().getSchema();
            if (StringUtils.isBlank(schema)) {
                String string = null;
                return string;
            }
            String string = schema;
            return string;
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
        finally {
            JdbcUtils.close(this.connection);
        }
    }

    private String verifySchema(DataSource dataSource) throws SQLException {
        String schema = dataSource instanceof HikariDataSource ? ((HikariDataSource)dataSource).getSchema() : dataSource.getConnection().getSchema();
        ResultSet resultSet = this.getConnection().getMetaData().getSchemas();
        while (resultSet.next()) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnValue = resultSet.getString(i);
                if (!StringUtils.isNotBlank(columnValue) || !columnValue.contains(schema)) continue;
                return schema;
            }
        }
        return null;
    }

    protected DatabaseMetaData getMetaData() throws QueryException {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    protected PreparedStatement prepareStatement(String sql) throws QueryException {
        Assert.notEmpty(sql, "Sql can not be empty!", new Object[0]);
        try {
            return this.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        throw ExceptionUtils.mpe("Not supported yet!", new Object[0]);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

