/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query;

import cn.smallbun.screw.core.query.DatabaseQuery;
import cn.smallbun.screw.core.query.OtherDataBaseQuery;
import cn.smallbun.screw.core.query.cachedb.CacheDbDataBaseQuery;
import cn.smallbun.screw.core.query.db2.Db2DataBaseQuery;
import cn.smallbun.screw.core.query.dm.DmDataBaseQuery;
import cn.smallbun.screw.core.query.h2.H2DataBaseQuery;
import cn.smallbun.screw.core.query.highgo.HigHgoDataBaseQuery;
import cn.smallbun.screw.core.query.hsql.HsqlDataBaseQuery;
import cn.smallbun.screw.core.query.mariadb.MariaDbDataBaseQuery;
import cn.smallbun.screw.core.query.mysql.MySqlDataBaseQuery;
import cn.smallbun.screw.core.query.oracle.OracleDataBaseQuery;
import cn.smallbun.screw.core.query.phoenix.PhoenixDataBaseQuery;
import cn.smallbun.screw.core.query.postgresql.PostgreSqlDataBaseQuery;
import cn.smallbun.screw.core.query.sqlite.SqliteDataBaseQuery;
import cn.smallbun.screw.core.query.sqlservice.SqlServerDataBaseQuery;
import java.io.Serializable;

public enum DatabaseType implements Serializable
{
    MYSQL("mysql", "MySql\u6570\u636e\u5e93", MySqlDataBaseQuery.class),
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93", MariaDbDataBaseQuery.class),
    ORACLE("oracle", "Oracle\u6570\u636e\u5e93", OracleDataBaseQuery.class),
    DB2("db2", "DB2\u6570\u636e\u5e93", Db2DataBaseQuery.class),
    H2("h2", "H2\u6570\u636e\u5e93", H2DataBaseQuery.class),
    HSQL("hsql", "HSQL\u6570\u636e\u5e93", HsqlDataBaseQuery.class),
    SQLITE("sqlite", "SQLite\u6570\u636e\u5e93", SqliteDataBaseQuery.class),
    POSTGRE_SQL("PostgreSql", "Postgre\u6570\u636e\u5e93", PostgreSqlDataBaseQuery.class),
    SQL_SERVER2005("sqlServer2005", "SQLServer2005\u6570\u636e\u5e93", SqlServerDataBaseQuery.class),
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93", SqlServerDataBaseQuery.class),
    DM("dm", "\u8fbe\u68a6\u6570\u636e\u5e93", DmDataBaseQuery.class),
    HIGHGO("highgo", "\u701a\u9ad8\u6570\u636e\u5e93", HigHgoDataBaseQuery.class),
    XU_GU("xugu", "\u865a\u8c37\u6570\u636e\u5e93", OtherDataBaseQuery.class),
    KINGBASE_ES("kingbasees", "\u4eba\u5927\u91d1\u4ed3\u6570\u636e\u5e93", OtherDataBaseQuery.class),
    PHOENIX("phoenix", "Phoenix HBase\u6570\u636e\u5e93", PhoenixDataBaseQuery.class),
    CACHEDB("cachedb", "Cache \u6570\u636e\u5e93", CacheDbDataBaseQuery.class),
    OTHER("other", "\u5176\u4ed6\u6570\u636e\u5e93", OtherDataBaseQuery.class);

    private final String name;
    private final String desc;
    private final Class<? extends DatabaseQuery> implClass;

    private DatabaseType(String name, String desc, Class<? extends DatabaseQuery> query) {
        this.name = name;
        this.desc = desc;
        this.implClass = query;
    }

    public static DatabaseType getType(String dbType) {
        DatabaseType[] dts;
        for (DatabaseType dt : dts = DatabaseType.values()) {
            if (!dt.getName().equalsIgnoreCase(dbType)) continue;
            return dt;
        }
        return OTHER;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class<? extends DatabaseQuery> getImplClass() {
        return this.implClass;
    }
}

