/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.db2;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.metadata.Table;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.db2.model.Db2ColumnModel;
import cn.smallbun.screw.core.query.db2.model.Db2DatabaseModel;
import cn.smallbun.screw.core.query.db2.model.Db2PrimaryKeyModel;
import cn.smallbun.screw.core.query.db2.model.Db2TableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class Db2DataBaseQuery
extends AbstractDatabaseQuery {
    public Db2DataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        Db2DatabaseModel model = new Db2DatabaseModel();
        model.setDatabase(StringUtils.trim((String)this.getSchema()));
        return model;
    }

    public List<Db2TableModel> getTables() {
        List<Db2TableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, Db2TableModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    public List<Db2ColumnModel> getTableColumns(String table) throws QueryException {
        List<Db2ColumnModel> list;
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            List<Db2ColumnModel> list2;
            if ("%".equals(table)) {
                List tableNames = this.getTables().stream().map(Table::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
                list2 = new ArrayList();
                for (String tableName : tableNames) {
                    list2.addAll(this.getTableColumns(tableName));
                }
            } else if (!this.columnsCaching.containsKey(table)) {
                resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
                list2 = Mapping.convertList(resultSet, Db2ColumnModel.class);
                String sql = "SELECT COLNAME as NAME,TABNAME as TABLE_NAME,REMARKS,LENGTH as COLUMN_LENGTH, TYPENAME ||'('|| LENGTH ||')'  as COLUMN_TYPE,SCALE as DECIMAL_DIGITS   FROM SYSCAT.COLUMNS WHERE TABSCHEMA='" + StringUtils.trim((String)this.getSchema()) + "' and TABNAME = '%s' ORDER BY COLNO";
                resultSet = this.prepareStatement(String.format(sql, table)).executeQuery();
                List<Db2ColumnModel> inquires = Mapping.convertListByColumnLabel(resultSet, Db2ColumnModel.class);
                for (Db2ColumnModel i2 : list2) {
                    inquires.forEach(j -> {
                        if (i2.getColumnName().equals(j.getColumnName())) {
                            i2.setRemarks(j.getRemarks());
                            i2.setColumnLength(j.getColumnLength());
                            i2.setColumnType(j.getColumnType());
                            i2.setTableName(j.getTableName());
                            i2.setDecimalDigits(j.getDecimalDigits());
                            if ("NO".equals(i2.getNullable())) {
                                i2.setNullable("0");
                            }
                        }
                    });
                }
                this.columnsCaching.put(table, list2.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getColumnName())).collect(Collectors.toList()));
            } else {
                list2 = ((List)this.columnsCaching.get(table)).stream().map(c -> (Db2ColumnModel)c).collect(Collectors.toList());
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<Db2PrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, Db2PrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<Db2PrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT TABSCHEMA as TABLE_SCHEM, TABNAME as TABLE_NAME ,COLNAME as COLUMN_NAME,KEYSEQ as KEY_SEQ   FROM SYSCAT.COLUMNS WHERE TABSCHEMA = '%s' AND KEYSEQ IS NOT NULL ORDER BY KEYSEQ";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertListByColumnLabel(resultSet, Db2PrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }
}

