/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.dm;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.dm.model.DmColumnModel;
import cn.smallbun.screw.core.query.dm.model.DmDatabaseModel;
import cn.smallbun.screw.core.query.dm.model.DmPrimaryKeyModel;
import cn.smallbun.screw.core.query.dm.model.DmTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;

public class DmDataBaseQuery
extends AbstractDatabaseQuery {
    private final ConcurrentMap<String, List<DmTableModel>> tablesMap = new ConcurrentHashMap<String, List<DmTableModel>>();
    private static final String DM_QUERY_TABLE_SQL = "select ut.table_name TABLE_NAME, utc.comments COMMENTS from user_tables ut left join USER_TAB_COMMENTS utc on ut.table_name = utc.table_name";
    private static final String DM_QUERY_COLUMNS_SQL = "SELECT\n    ut.table_name AS TABLE_NAME,\n    uc.column_name AS COLUMN_NAME,\n    CASE uc.data_type\n        WHEN 'CLOB' THEN\n            uc.data_type\n        WHEN 'BLOB' THEN\n            uc.data_type\n        ELSE\n            CONCAT(CONCAT(CONCAT(uc.data_type, '('), uc.data_length), ')')\n    END AS COLUMN_TYPE,\n    uc.data_length AS COLUMN_LENGTH,\n    uc.DATA_PRECISION AS DATA_PRECISION,\n    uc.DATA_SCALE AS DECIMAL_DIGITS,\n    CASE uc.NULLABLE\n        WHEN 'Y' THEN\n            '1'\n        ELSE\n            '0'\n    END AS NULLABLE,\n    uc.DATA_DEFAULT AS COLUMN_DEF,\n    ucc.comments AS REMARKS\nFROM\n    all_tables ut\n    LEFT JOIN all_tab_comments utc ON ut.table_name = utc.table_name AND ut.owner = utc.owner\n    LEFT JOIN all_tab_columns uc ON ut.owner = uc.owner AND ut.table_name = uc.table_name\n    LEFT JOIN all_col_comments ucc ON uc.owner = ucc.owner AND uc.table_name = ucc.table_name AND uc.column_name = ucc.column_name\nWHERE 1 = 1 ";
    private static final String DM_QUERY_PK_SQL = "SELECT C.OWNER AS TABLE_SCHEM, C.TABLE_NAME, C.COLUMN_NAME, C.POSITION AS KEY_SEQ, C.CONSTRAINT_NAME AS PK_NAME FROM ALL_CONS_COLUMNS C, ALL_CONSTRAINTS K WHERE K.CONSTRAINT_TYPE = 'P' AND K.OWNER = '%s' AND K.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND K.TABLE_NAME = C.TABLE_NAME AND K.OWNER = C.OWNER";

    public DmDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        DmDatabaseModel model = new DmDatabaseModel();
        model.setDatabase(this.getSchema());
        return model;
    }

    @Override
    public String getSchema() throws QueryException {
        return super.getSchema();
    }

    public String getSchemaBak() throws QueryException {
        try {
            String schema = null;
            ResultSet rs = this.getMetaData().getSchemas();
            if (rs.next()) {
                schema = rs.getString(1);
            }
            return schema;
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    public List<DmTableModel> getTables() throws QueryException {
        List<DmTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getSchema(), this.getSchema(), "%", new String[]{"TABLE"});
            List<DmTableModel> list2 = Mapping.convertList(resultSet, DmTableModel.class);
            resultSet = this.prepareStatement(DM_QUERY_TABLE_SQL).executeQuery();
            List<DmTableModel> inquires = Mapping.convertList(resultSet, DmTableModel.class);
            list2.forEach(model -> inquires.stream().filter(inquire -> model.getTableName().equals(inquire.getTableName())).forEachOrdered(inquire -> model.setRemarks(inquire.getRemarks())));
            if (!list2.isEmpty()) {
                this.tablesMap.put("AllTable", list2);
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    public List<DmColumnModel> getTableColumns(String table) throws QueryException {
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            Object object;
            List<DmTableModel> tables = (List<DmTableModel>)this.tablesMap.get("AllTable");
            if (tables.isEmpty()) {
                tables = this.getTables();
            } else {
                for (DmTableModel dtm : tables) {
                    tableNames.add(dtm.getTableName());
                }
            }
            if (tableNames.isEmpty()) {
                object = null;
                return object;
            }
            if (table.equals("%")) {
                String sql = String.format(DM_QUERY_COLUMNS_SQL.concat(" AND ut.owner = '%s'"), this.getSchema());
                PreparedStatement statement = this.prepareStatement(sql);
                resultSet = statement.executeQuery();
            } else {
                String singleTableSql = DM_QUERY_COLUMNS_SQL.concat(" and ut.table_name='%s'");
                resultSet = this.prepareStatement(String.format(singleTableSql, table)).executeQuery();
            }
            object = Mapping.convertListByColumnLabel(resultSet, DmColumnModel.class);
            JdbcUtils.close(resultSet, this.connection);
            return object;
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe(e);
        }
        finally {
            JdbcUtils.close(resultSet, this.connection);
        }
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<DmPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getSchema(), this.getSchema(), table);
            list = Mapping.convertListByColumnLabel(resultSet, DmPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<DmPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = String.format(DM_QUERY_PK_SQL, this.getSchema());
            resultSet = this.prepareStatement(sql).executeQuery();
            list = Mapping.convertListByColumnLabel(resultSet, DmPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }
}

