/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.config.Lookup;
import io.sentry.dsn.Dsn;
import io.sentry.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SentryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SentryClientFactory.class);

    public static SentryClient sentryClient(String dsn) {
        return SentryClientFactory.sentryClient(dsn, null);
    }

    public static SentryClient sentryClient(String dsn, SentryClientFactory sentryClientFactory) {
        Dsn realDsn = SentryClientFactory.resolveDsn(dsn);
        if (sentryClientFactory == null) {
            String sentryClientFactoryName = Lookup.lookup("factory", realDsn);
            if (Util.isNullOrEmpty(sentryClientFactoryName)) {
                sentryClientFactory = new DefaultSentryClientFactory();
            } else {
                Class<?> factoryClass = null;
                try {
                    factoryClass = Class.forName(sentryClientFactoryName);
                    sentryClientFactory = (SentryClientFactory)factoryClass.newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error("Error creating SentryClient using factory class: '" + sentryClientFactoryName + "'.", (Throwable)e);
                    return null;
                }
            }
        }
        return sentryClientFactory.createSentryClient(realDsn);
    }

    private static Dsn resolveDsn(String dsn) {
        try {
            if (Util.isNullOrEmpty(dsn)) {
                dsn = Dsn.dsnLookup();
            }
            return new Dsn(dsn);
        }
        catch (Exception e) {
            logger.error("Error creating valid DSN from: '{}'.", (Object)dsn, (Object)e);
            throw e;
        }
    }

    public abstract SentryClient createSentryClient(Dsn var1);

    public String toString() {
        return "SentryClientFactory{name='" + this.getClass().getName() + '\'' + '}';
    }
}

