/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config;

import io.sentry.config.JndiLookup;
import io.sentry.dsn.Dsn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Lookup {
    private static final Logger logger = LoggerFactory.getLogger(Lookup.class);
    private static final String CONFIG_FILE_NAME = "sentry.properties";
    private static Properties configProps;

    private Lookup() {
    }

    private static String getConfigFilePath() {
        String filePath = System.getProperty("sentry.properties.file");
        if (filePath == null) {
            filePath = System.getenv("SENTRY_PROPERTIES_FILE");
        }
        if (filePath == null) {
            filePath = CONFIG_FILE_NAME;
        }
        return filePath;
    }

    private static InputStream getInputStream(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        if (file.isFile() && file.canRead()) {
            return new FileInputStream(file);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(filePath);
    }

    public static String lookup(String key) {
        return Lookup.lookup(key, null);
    }

    public static String lookup(String key, Dsn dsn) {
        String value = null;
        try {
            Class.forName("javax.naming.InitialContext", false, Dsn.class.getClassLoader());
            value = JndiLookup.jndiLookup(key);
            if (value != null) {
                logger.debug("Found {}={} in JNDI.", (Object)key, (Object)value);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            logger.trace("JNDI not available", e);
        }
        if (value == null && (value = System.getProperty("sentry." + key.toLowerCase())) != null) {
            logger.debug("Found {}={} in Java System Properties.", (Object)key, (Object)value);
        }
        if (value == null && (value = System.getenv("SENTRY_" + key.replace(".", "_").toUpperCase())) != null) {
            logger.debug("Found {}={} in System Environment Variables.", (Object)key, (Object)value);
        }
        if (value == null && dsn != null && (value = dsn.getOptions().get(key)) != null) {
            logger.debug("Found {}={} in DSN.", (Object)key, (Object)value);
        }
        if (value == null && configProps != null && (value = configProps.getProperty(key)) != null) {
            logger.debug("Found {}={} in {}.", new Object[]{key, value, CONFIG_FILE_NAME});
        }
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    static {
        String filePath = Lookup.getConfigFilePath();
        try {
            InputStream input = Lookup.getInputStream(filePath);
            if (input != null) {
                configProps = new Properties();
                configProps.load(input);
            } else {
                logger.debug("Sentry configuration file not found in filesystem or classpath: '{}'.", (Object)filePath);
            }
        }
        catch (Exception e) {
            logger.error("Error loading Sentry configuration file '{}': ", (Object)filePath, (Object)e);
        }
    }
}

