/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.connection;

import io.sentry.connection.Connection;
import io.sentry.connection.ConnectionException;
import io.sentry.connection.EventSendCallback;
import io.sentry.connection.LockdownManager;
import io.sentry.connection.LockedDownException;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Connection {
    public static final String SENTRY_PROTOCOL_VERSION = "6";
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnection.class);
    private final String authHeader;
    private Set<EventSendCallback> eventSendCallbacks;
    private LockdownManager lockdownManager = new LockdownManager();

    protected AbstractConnection(String publicKey, String secretKey) {
        this.eventSendCallbacks = new HashSet<EventSendCallback>();
        this.authHeader = "Sentry sentry_version=6,sentry_client=" + SentryEnvironment.getSentryName() + "," + "sentry_key=" + publicKey + "," + "sentry_secret=" + secretKey;
    }

    protected String getAuthHeader() {
        return this.authHeader;
    }

    @Override
    public final void send(Event event) throws ConnectionException {
        try {
            if (this.lockdownManager.isLockedDown()) {
                throw new LockedDownException("Dropping an Event due to lockdown: " + event);
            }
            this.doSend(event);
            for (EventSendCallback eventSendCallback : this.eventSendCallbacks) {
                try {
                    eventSendCallback.onSuccess(event);
                }
                catch (Exception exc) {
                    logger.warn("An exception occurred while running an EventSendCallback.onSuccess: " + eventSendCallback.getClass().getName(), (Throwable)exc);
                }
            }
            this.lockdownManager.resetState();
        }
        catch (ConnectionException e) {
            for (EventSendCallback eventSendCallback : this.eventSendCallbacks) {
                try {
                    eventSendCallback.onFailure(event, e);
                }
                catch (Exception exc) {
                    logger.warn("An exception occurred while running an EventSendCallback.onFailure: " + eventSendCallback.getClass().getName(), (Throwable)exc);
                }
            }
            logger.warn("An exception due to the connection occurred, a lockdown will be initiated.", (Throwable)e);
            this.lockdownManager.setState(e);
            throw e;
        }
    }

    protected abstract void doSend(Event var1) throws ConnectionException;

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.eventSendCallbacks.add(eventSendCallback);
    }
}

