/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IExceptionTableEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileStruct;

public class ExceptionTableEntry
extends ClassFileStruct
implements IExceptionTableEntry {
    private int startPC;
    private int endPC;
    private int handlerPC;
    private int catchTypeIndex;
    private char[] catchType;

    ExceptionTableEntry(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.startPC = this.u2At(classFileBytes, 0, offset);
        this.endPC = this.u2At(classFileBytes, 2, offset);
        this.handlerPC = this.u2At(classFileBytes, 4, offset);
        this.catchTypeIndex = this.u2At(classFileBytes, 6, offset);
        if (this.catchTypeIndex != 0) {
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.catchTypeIndex);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.catchType = constantPoolEntry.getClassInfoName();
        }
    }

    @Override
    public int getStartPC() {
        return this.startPC;
    }

    @Override
    public int getEndPC() {
        return this.endPC;
    }

    @Override
    public int getHandlerPC() {
        return this.handlerPC;
    }

    @Override
    public int getCatchTypeIndex() {
        return this.catchTypeIndex;
    }

    @Override
    public char[] getCatchType() {
        return this.catchType;
    }
}

