/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IMethodParametersAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;

public class MethodParametersAttribute
extends ClassFileAttribute
implements IMethodParametersAttribute {
    private static final char[][] NO_NAMES = new char[0][];
    private static final short[] NO_ACCES_FLAGS = new short[0];
    private final int numberOfEntries;
    private final char[][] names;
    private final short[] accessFlags;

    MethodParametersAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.numberOfEntries = length = this.u1At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = offset + 7;
            this.names = new char[length][];
            this.accessFlags = new short[length];
            int i = 0;
            while (i < length) {
                int nameIndex = this.u2At(classFileBytes, 0, readOffset);
                int mask = this.u2At(classFileBytes, 2, readOffset);
                readOffset += 4;
                if (nameIndex != 0) {
                    IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(nameIndex);
                    if (constantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.names[i] = constantPoolEntry.getUtf8Value();
                } else {
                    this.names[i] = null;
                }
                this.accessFlags[i] = (short)(mask & 0xFFFF);
                ++i;
            }
        } else {
            this.names = NO_NAMES;
            this.accessFlags = NO_ACCES_FLAGS;
        }
    }

    @Override
    public int getMethodParameterLength() {
        return this.numberOfEntries;
    }

    @Override
    public char[] getParameterName(int i) {
        return this.names[i];
    }

    @Override
    public short getAccessFlags(int i) {
        return this.accessFlags[i];
    }
}

