/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IParameterAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Annotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileStruct;

public class ParameterAnnotation
extends ClassFileStruct
implements IParameterAnnotation {
    private static final IAnnotation[] NO_ENTRIES = new IAnnotation[0];
    private int annotationsNumber;
    private IAnnotation[] annotations;
    private int readOffset;

    public ParameterAnnotation(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int length = this.u2At(classFileBytes, 0, offset);
        this.readOffset = 2;
        this.annotationsNumber = length;
        if (length != 0) {
            this.annotations = new IAnnotation[length];
            int i = 0;
            while (i < length) {
                Annotation annotation = new Annotation(classFileBytes, constantPool, offset + this.readOffset);
                this.annotations[i] = annotation;
                this.readOffset += annotation.sizeInBytes();
                ++i;
            }
        } else {
            this.annotations = NO_ENTRIES;
        }
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    @Override
    public IAnnotation[] getAnnotations() {
        return this.annotations;
    }
}

