/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IComponentInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IRecordAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ComponentInfo;

public class RecordAttribute
extends ClassFileAttribute
implements IRecordAttribute {
    private static final IComponentInfo[] NO_ENTRIES = new IComponentInfo[0];
    private int nComponents;
    private IComponentInfo[] entries;

    public RecordAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.nComponents = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new IComponentInfo[length];
            int i = 0;
            while (i < length) {
                this.entries[i] = new ComponentInfo(classFileBytes, constantPool, offset + readOffset);
                readOffset += this.entries[i].sizeInBytes();
                ++i;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    @Override
    public IComponentInfo[] getComponentInfos() {
        return this.entries;
    }
}

