/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config;

import io.zeebe.exporters.kafka.config.ProducerConfig;
import io.zeebe.exporters.kafka.config.RecordsConfig;
import java.time.Duration;
import java.util.Objects;

public final class Config {
    private final ProducerConfig producer;
    private final RecordsConfig records;
    private final int maxBatchSize;
    private final Duration flushInterval;

    public Config(ProducerConfig producer, RecordsConfig records, int maxBatchSize, Duration flushInterval) {
        this.producer = Objects.requireNonNull(producer);
        this.records = Objects.requireNonNull(records);
        this.maxBatchSize = maxBatchSize;
        this.flushInterval = Objects.requireNonNull(flushInterval);
    }

    public ProducerConfig getProducer() {
        return this.producer;
    }

    public RecordsConfig getRecords() {
        return this.records;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration getFlushInterval() {
        return this.flushInterval;
    }

    public int hashCode() {
        return Objects.hash(this.producer, this.records, this.maxBatchSize, this.flushInterval);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.getMaxBatchSize() == config.getMaxBatchSize() && Objects.equals(this.getProducer(), config.getProducer()) && Objects.equals(this.getRecords(), config.getRecords()) && Objects.equals(this.getMaxBatchSize(), config.getMaxBatchSize()) && Objects.equals(this.getFlushInterval(), config.getFlushInterval());
    }

    public String toString() {
        return "Config{producer=" + this.producer + ", records=" + this.records + ", maxBatchSize=" + this.maxBatchSize + ", commitInterval=" + this.flushInterval + "}";
    }
}

