/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ProducerConfig {
    private final String clientId;
    private final Duration closeTimeout;
    private final Map<String, Object> config;
    private final Duration requestTimeout;
    private final Duration maxBlockingTimeout;
    private final List<String> servers;

    public ProducerConfig(String clientId, Duration closeTimeout, Map<String, Object> config, Duration requestTimeout, Duration maxBlockingTimeout, List<String> servers) {
        this.clientId = Objects.requireNonNull(clientId);
        this.closeTimeout = Objects.requireNonNull(closeTimeout);
        this.config = Objects.requireNonNull(config);
        this.requestTimeout = Objects.requireNonNull(requestTimeout);
        this.maxBlockingTimeout = Objects.requireNonNull(maxBlockingTimeout);
        this.servers = Objects.requireNonNull(servers);
    }

    public String getClientId() {
        return this.clientId;
    }

    public Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public Duration getMaxBlockingTimeout() {
        return this.maxBlockingTimeout;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.closeTimeout, this.config, this.requestTimeout, this.maxBlockingTimeout, this.servers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProducerConfig that = (ProducerConfig)o;
        return Objects.equals(this.getClientId(), that.getClientId()) && Objects.equals(this.getCloseTimeout(), that.getCloseTimeout()) && Objects.equals(this.getConfig(), that.getConfig()) && Objects.equals(this.getRequestTimeout(), that.getRequestTimeout()) && Objects.equals(this.getMaxBlockingTimeout(), that.getMaxBlockingTimeout()) && Objects.equals(this.getServers(), that.getServers());
    }

    public String toString() {
        return "ProducerConfig{clientId='" + this.clientId + "', closeTimeout=" + this.closeTimeout + ", config=" + this.config + ", requestTimeout=" + this.requestTimeout + ", maxBlockingTimeout=" + this.maxBlockingTimeout + ", servers=" + this.servers + "}";
    }
}

