/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config;

import io.camunda.zeebe.protocol.record.RecordType;
import java.util.Objects;
import java.util.Set;

public final class RecordConfig {
    private final Set<RecordType> allowedTypes;
    private final String topic;

    public RecordConfig(Set<RecordType> allowedTypes, String topic) {
        this.allowedTypes = Objects.requireNonNull(allowedTypes);
        this.topic = Objects.requireNonNull(topic);
    }

    public Set<RecordType> getAllowedTypes() {
        return this.allowedTypes;
    }

    public String getTopic() {
        return this.topic;
    }

    public int hashCode() {
        return Objects.hash(this.allowedTypes, this.topic);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordConfig that = (RecordConfig)o;
        return Objects.equals(this.getAllowedTypes(), that.getAllowedTypes()) && Objects.equals(this.getTopic(), that.getTopic());
    }

    public String toString() {
        return "RecordConfig{allowedTypes=" + this.allowedTypes + ", topic='" + this.topic + "'}";
    }
}

