/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config;

import io.camunda.zeebe.protocol.record.ValueType;
import io.zeebe.exporters.kafka.config.RecordConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class RecordsConfig {
    private final Map<ValueType, RecordConfig> typeMap;
    private final RecordConfig defaults;

    public RecordsConfig(Map<ValueType, RecordConfig> typeMap, RecordConfig defaults) {
        this.typeMap = Objects.requireNonNull(typeMap);
        this.defaults = Objects.requireNonNull(defaults);
    }

    public Map<ValueType, RecordConfig> getTypeMap() {
        return this.typeMap;
    }

    public RecordConfig getDefaults() {
        return this.defaults;
    }

    public RecordConfig forType(ValueType type) {
        return Optional.ofNullable(this.typeMap.get(type)).orElse(this.defaults);
    }

    public int hashCode() {
        return Objects.hash(this.defaults, this.typeMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordsConfig that = (RecordsConfig)o;
        return Objects.equals(this.getTypeMap(), that.getTypeMap()) && Objects.equals(this.getDefaults(), that.getDefaults());
    }

    public String toString() {
        return "RecordsConfig{typeMap=" + this.typeMap + ", defaults=" + this.defaults + "}";
    }
}

