/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config.parser;

import io.camunda.zeebe.protocol.record.RecordType;
import java.util.Objects;

public enum AllowedType {
    COMMAND("command", RecordType.COMMAND),
    EVENT("event", RecordType.EVENT),
    REJECTION("rejection", RecordType.COMMAND_REJECTION);

    private final String typeName;
    private final RecordType recordType;

    private AllowedType(String typeName, RecordType recordType) {
        this.typeName = Objects.requireNonNull(typeName);
        this.recordType = Objects.requireNonNull(recordType);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public static AllowedType forName(String name) {
        if (AllowedType.COMMAND.typeName.equals(name)) {
            return COMMAND;
        }
        if (AllowedType.EVENT.typeName.equals(name)) {
            return EVENT;
        }
        if (AllowedType.REJECTION.typeName.equals(name)) {
            return REJECTION;
        }
        throw new IllegalArgumentException("Unknown record type name: " + name);
    }
}

