/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

final class ConfigParserUtil {
    private ConfigParserUtil() {
    }

    static <T> T get(T property, T fallback) {
        return Optional.ofNullable(property).orElse(fallback);
    }

    static <T, R> R get(T property, R fallback, Function<T, R> transformer) {
        return Optional.ofNullable(property).map(transformer).orElse(fallback);
    }

    static List<String> splitCommaSeparatedString(String value) {
        return Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

