/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config.parser;

import io.zeebe.exporters.kafka.config.Config;
import io.zeebe.exporters.kafka.config.ProducerConfig;
import io.zeebe.exporters.kafka.config.RecordsConfig;
import io.zeebe.exporters.kafka.config.parser.ConfigParser;
import io.zeebe.exporters.kafka.config.parser.ConfigParserUtil;
import io.zeebe.exporters.kafka.config.parser.RawProducerConfigParser;
import io.zeebe.exporters.kafka.config.parser.RawRecordsConfigParser;
import io.zeebe.exporters.kafka.config.raw.RawConfig;
import io.zeebe.exporters.kafka.config.raw.RawProducerConfig;
import io.zeebe.exporters.kafka.config.raw.RawRecordsConfig;
import java.time.Duration;
import java.util.Objects;

public final class RawConfigParser
implements ConfigParser<RawConfig, Config> {
    static final int DEFAULT_MAX_BATCH_SIZE = 100;
    static final Duration DEFAULT_FLUSH_INTERVAL_MS = Duration.ofSeconds(1L);
    private final ConfigParser<RawRecordsConfig, RecordsConfig> recordsConfigParser;
    private final ConfigParser<RawProducerConfig, ProducerConfig> producerConfigParser;

    public RawConfigParser() {
        this(new RawRecordsConfigParser(), new RawProducerConfigParser());
    }

    RawConfigParser(ConfigParser<RawRecordsConfig, RecordsConfig> recordsConfigParser, ConfigParser<RawProducerConfig, ProducerConfig> producerConfigParser) {
        this.recordsConfigParser = Objects.requireNonNull(recordsConfigParser);
        this.producerConfigParser = Objects.requireNonNull(producerConfigParser);
    }

    @Override
    public Config parse(RawConfig config) {
        Objects.requireNonNull(config);
        ProducerConfig producerConfig = this.producerConfigParser.parse(config.producer, RawProducerConfig::new);
        RecordsConfig recordsConfig = this.recordsConfigParser.parse(config.records, RawRecordsConfig::new);
        Integer maxBatchSize = ConfigParserUtil.get(config.maxBatchSize, 100);
        Duration flushInterval = ConfigParserUtil.get(config.flushIntervalMs, DEFAULT_FLUSH_INTERVAL_MS, Duration::ofMillis);
        return new Config(producerConfig, recordsConfig, maxBatchSize, flushInterval);
    }
}

