/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config.parser;

import io.zeebe.exporters.kafka.config.ProducerConfig;
import io.zeebe.exporters.kafka.config.parser.ConfigParser;
import io.zeebe.exporters.kafka.config.parser.ConfigParserUtil;
import io.zeebe.exporters.kafka.config.raw.RawProducerConfig;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class RawProducerConfigParser
implements ConfigParser<RawProducerConfig, ProducerConfig> {
    public static final Duration DEFAULT_MAX_BLOCKING_TIMEOUT = Duration.ofSeconds(2L);
    static final List<String> DEFAULT_SERVERS = Collections.singletonList("localhost:9092");
    static final String DEFAULT_CLIENT_ID = "zeebe";
    static final Duration DEFAULT_CLOSE_TIMEOUT = Duration.ofSeconds(20L);
    static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(5L);

    @Override
    public ProducerConfig parse(RawProducerConfig config) {
        Objects.requireNonNull(config);
        List servers = ConfigParserUtil.get(config.servers, DEFAULT_SERVERS, ConfigParserUtil::splitCommaSeparatedString);
        String clientId = ConfigParserUtil.get(config.clientId, DEFAULT_CLIENT_ID);
        Duration closeTimeout = ConfigParserUtil.get(config.closeTimeoutMs, DEFAULT_CLOSE_TIMEOUT, Duration::ofMillis);
        Duration requestTimeout = ConfigParserUtil.get(config.requestTimeoutMs, DEFAULT_REQUEST_TIMEOUT, Duration::ofMillis);
        Duration maxBlockingTimeout = ConfigParserUtil.get(config.maxBlockingTimeoutMs, DEFAULT_MAX_BLOCKING_TIMEOUT, Duration::ofMillis);
        Map producerConfig = ConfigParserUtil.get(config.config, new HashMap(), this::parseProperties);
        return new ProducerConfig(clientId, closeTimeout, producerConfig, requestTimeout, maxBlockingTimeout, servers);
    }

    private Map<String, Object> parseProperties(String propertiesString) {
        Properties properties = new Properties();
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        try {
            properties.load(new StringReader(propertiesString));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (String property : properties.stringPropertyNames()) {
            parsed.put(property, properties.get(property));
        }
        return parsed;
    }
}

