/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config.parser;

import io.camunda.zeebe.protocol.record.RecordType;
import io.zeebe.exporters.kafka.config.RecordConfig;
import io.zeebe.exporters.kafka.config.parser.AllowedType;
import io.zeebe.exporters.kafka.config.parser.ConfigParser;
import io.zeebe.exporters.kafka.config.parser.ConfigParserUtil;
import io.zeebe.exporters.kafka.config.raw.RawRecordConfig;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class RawRecordConfigParser
implements ConfigParser<RawRecordConfig, RecordConfig> {
    static final String DEFAULT_TOPIC_NAME = "zeebe";
    static final EnumSet<RecordType> DEFAULT_ALLOWED_TYPES = EnumSet.complementOf(EnumSet.of(RecordType.NULL_VAL, RecordType.SBE_UNKNOWN));
    private final RecordConfig defaults;

    public RawRecordConfigParser() {
        this(new RecordConfig(DEFAULT_ALLOWED_TYPES, DEFAULT_TOPIC_NAME));
    }

    public RawRecordConfigParser(RecordConfig defaults) {
        this.defaults = defaults;
    }

    @Override
    public RecordConfig parse(RawRecordConfig config) {
        Set<RecordType> allowedTypes;
        Objects.requireNonNull(config);
        String topic = Optional.ofNullable(config.topic).orElse(this.defaults.getTopic());
        if (config.type != null) {
            allowedTypes = EnumSet.noneOf(RecordType.class);
            ConfigParserUtil.get(config.type, Collections.emptyList(), ConfigParserUtil::splitCommaSeparatedString).stream().filter(Predicate.not(String::isBlank)).forEach(t -> allowedTypes.add(AllowedType.forName(t).getRecordType()));
        } else {
            allowedTypes = this.defaults.getAllowedTypes();
        }
        return new RecordConfig(allowedTypes, topic);
    }
}

