/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.config.parser;

import io.camunda.zeebe.protocol.record.ValueType;
import io.zeebe.exporters.kafka.config.RecordConfig;
import io.zeebe.exporters.kafka.config.RecordsConfig;
import io.zeebe.exporters.kafka.config.parser.ConfigParser;
import io.zeebe.exporters.kafka.config.parser.RawRecordConfigParser;
import io.zeebe.exporters.kafka.config.raw.RawRecordConfig;
import io.zeebe.exporters.kafka.config.raw.RawRecordsConfig;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;

public class RawRecordsConfigParser
implements ConfigParser<RawRecordsConfig, RecordsConfig> {
    private static final ConfigParser<RawRecordConfig, RecordConfig> DEFAULTS_RECORD_CONFIG_PARSER = new RawRecordConfigParser();

    @Override
    public RecordsConfig parse(RawRecordsConfig config) {
        Objects.requireNonNull(config);
        EnumMap<ValueType, RecordConfig> typeMap = new EnumMap<ValueType, RecordConfig>(ValueType.class);
        RecordConfig defaults = DEFAULTS_RECORD_CONFIG_PARSER.parse(config.defaults, RawRecordConfig::new);
        RawRecordConfigParser recordConfigParser = new RawRecordConfigParser(defaults);
        Optional.ofNullable(config.deployment).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.DEPLOYMENT, (RecordConfig)c));
        Optional.ofNullable(config.deploymentDistribution).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.DEPLOYMENT_DISTRIBUTION, (RecordConfig)c));
        Optional.ofNullable(config.error).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.ERROR, (RecordConfig)c));
        Optional.ofNullable(config.incident).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.INCIDENT, (RecordConfig)c));
        Optional.ofNullable(config.job).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.JOB, (RecordConfig)c));
        Optional.ofNullable(config.jobBatch).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.JOB_BATCH, (RecordConfig)c));
        Optional.ofNullable(config.message).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.MESSAGE, (RecordConfig)c));
        Optional.ofNullable(config.messageSubscription).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.MESSAGE_SUBSCRIPTION, (RecordConfig)c));
        Optional.ofNullable(config.messageStartEventSubscription).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, (RecordConfig)c));
        Optional.ofNullable(config.processInstance).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.PROCESS_INSTANCE, (RecordConfig)c));
        Optional.ofNullable(config.processInstanceCreation).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.PROCESS_INSTANCE_CREATION, (RecordConfig)c));
        Optional.ofNullable(config.processInstanceResult).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.PROCESS_INSTANCE_RESULT, (RecordConfig)c));
        Optional.ofNullable(config.processMessageSubscription).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (RecordConfig)c));
        Optional.ofNullable(config.process).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.PROCESS, (RecordConfig)c));
        Optional.ofNullable(config.processEvent).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.PROCESS_EVENT, (RecordConfig)c));
        Optional.ofNullable(config.timer).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.TIMER, (RecordConfig)c));
        Optional.ofNullable(config.variable).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.VARIABLE, (RecordConfig)c));
        Optional.ofNullable(config.variableDocument).map(recordConfigParser::parse).ifPresent(c -> typeMap.put(ValueType.VARIABLE_DOCUMENT, (RecordConfig)c));
        return new RecordsConfig(typeMap, defaults);
    }
}

