/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.producer;

import io.zeebe.exporters.kafka.config.ProducerConfig;
import io.zeebe.exporters.kafka.producer.KafkaProducerFactory;
import io.zeebe.exporters.kafka.producer.RecordIdPartitioner;
import io.zeebe.exporters.kafka.serde.RecordId;
import io.zeebe.exporters.kafka.serde.RecordIdSerializer;
import java.util.HashMap;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

final class DefaultKafkaProducerFactory
implements KafkaProducerFactory {
    DefaultKafkaProducerFactory() {
    }

    @Override
    public Producer<RecordId, byte[]> newProducer(ProducerConfig config, String producerId) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String clientId = String.format("%s-%s", config.getClientId(), producerId);
        options.put("transactional.id", producerId);
        options.put("client.id", clientId);
        options.put("enable.idempotence", true);
        options.put("max.in.flight.requests.per.connection", 1);
        options.put("delivery.timeout.ms", Integer.MAX_VALUE);
        options.put("request.timeout.ms", (int)config.getRequestTimeout().toMillis());
        options.put("bootstrap.servers", config.getServers());
        options.put("buffer.memory", 0x2800000L);
        options.put("linger.ms", 10L);
        options.put("batch.size", 0x400000L);
        options.put("max.block.ms", config.getMaxBlockingTimeout().toMillis());
        options.putAll(config.getConfig());
        options.put("key.serializer", RecordIdSerializer.class);
        options.put("value.serializer", ByteArraySerializer.class);
        options.put("partitioner.class", RecordIdPartitioner.class);
        return new KafkaProducer<RecordId, byte[]>(options);
    }
}

