/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.producer;

import io.zeebe.exporters.kafka.serde.RecordId;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordIdPartitioner
implements Partitioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordIdPartitioner.class);
    private final DefaultPartitioner defaultPartitioner = new DefaultPartitioner();

    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        if (!(key instanceof RecordId)) {
            LOGGER.warn("Expected to partition a RecordId object, but got {}; falling back to default partitioner", key.getClass());
            return this.defaultPartitioner.partition(topic, key, keyBytes, value, valueBytes, cluster);
        }
        List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
        int numPartitions = partitions.size();
        RecordId recordId = (RecordId)key;
        int partitionId = recordId.getPartitionId() % numPartitions;
        LOGGER.trace("Assigning partition {} to record ID {}", (Object)partitionId, (Object)recordId);
        return partitionId;
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }
}

