/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.record;

import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.zeebe.exporters.kafka.config.RecordsConfig;
import java.util.Objects;
import java.util.Optional;

public final class KafkaRecordFilter
implements Context.RecordFilter {
    private final RecordsConfig config;

    public KafkaRecordFilter(RecordsConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    public boolean acceptType(RecordType recordType) {
        return this.config.getDefaults().getAllowedTypes().contains(recordType) || this.config.getTypeMap().values().stream().anyMatch(c -> c.getAllowedTypes().contains(recordType));
    }

    public boolean acceptValue(ValueType valueType) {
        return !Optional.ofNullable(this.config.getTypeMap().get(valueType)).orElse(this.config.getDefaults()).getAllowedTypes().isEmpty();
    }
}

