/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.serde;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public abstract class JacksonDeserializer<T>
implements Deserializer<T> {
    protected final ObjectReader reader;

    protected JacksonDeserializer(ObjectReader reader) {
        this.reader = reader;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public T deserialize(String topic, byte[] data) {
        try {
            return this.reader.readValue(data);
        }
        catch (IOException e) {
            throw new SerializationException(String.format("Expected to deserialize data from topic [%s], but failed", topic), e);
        }
    }
}

