/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporters.kafka.serde;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public abstract class JacksonSerializer<T>
implements Serializer<T> {
    protected final ObjectWriter writer;

    protected JacksonSerializer(ObjectWriter writer) {
        this.writer = writer;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public byte[] serialize(String topic, T data) {
        try {
            return this.writer.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException(String.format("Expected to serialize data for topic [%s], but failed", topic), e);
        }
    }

    @Override
    public void close() {
    }
}

