/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.InvalidConfigurationException;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public interface CacheConfiguration {
    public boolean isReadThrough();

    public void setReadThrough(boolean var1);

    public boolean isWriteThrough();

    public void setWriteThrough(boolean var1);

    public boolean isStoreByValue();

    public boolean isStatisticsEnabled();

    public void setStatisticsEnabled(boolean var1);

    public boolean isTransactionEnabled();

    public IsolationLevel getTransactionIsolationLevel();

    public Mode getTransactionMode();

    public void setExpiry(ExpiryType var1, Duration var2);

    public Duration getExpiry(ExpiryType var1);

    public static enum ExpiryType {
        MODIFIED,
        ACCESSED;

    }

    public static class Duration {
        public static final Duration ETERNAL = new Duration(TimeUnit.SECONDS, 0L);
        private final TimeUnit timeUnit;
        private final long timeToLive;

        public Duration(TimeUnit timeUnit, long timeToLive) {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            switch (timeUnit) {
                case NANOSECONDS: 
                case MICROSECONDS: {
                    throw new InvalidConfigurationException();
                }
            }
            this.timeUnit = timeUnit;
            if (timeToLive < 0L) {
                throw new IllegalArgumentException();
            }
            this.timeToLive = timeToLive;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public long getTimeToLive() {
            return this.timeToLive;
        }
    }
}

