/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.AppletInitializer;
import com.googlecode.openbeans.CustomizedObjectInputStream;
import com.googlecode.openbeans.beancontext.BeanContext;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.harmony.beans.internal.nls.Messages;

public class Beans {
    private static boolean designTime = false;
    private static boolean guiAvailable = true;

    private static Object internalInstantiate(ClassLoader cls, String beanName, BeanContext context, Object initializer) throws IOException, ClassNotFoundException {
        ClassLoader classLoader;
        String beanResourceName = Beans.getBeanResourceName(beanName);
        InputStream is = cls == null ? ClassLoader.getSystemResourceAsStream(beanResourceName) : cls.getResourceAsStream(beanResourceName);
        IOException serializationException = null;
        Object result = null;
        if (is != null) {
            try {
                ObjectInputStream ois = cls == null ? new ObjectInputStream(is) : new CustomizedObjectInputStream(is, cls);
                result = ois.readObject();
            }
            catch (IOException e) {
                serializationException = e;
            }
        }
        boolean deserialized = true;
        ClassLoader classLoader2 = classLoader = cls == null ? ClassLoader.getSystemClassLoader() : cls;
        if (result == null) {
            deserialized = false;
            try {
                result = Class.forName(beanName, true, classLoader).newInstance();
            }
            catch (Exception e) {
                if (serializationException != null) {
                    throw serializationException;
                }
                throw new ClassNotFoundException(e.getClass() + ": " + e.getMessage());
            }
        }
        if (result != null) {
            boolean isApplet = false;
            try {
                isApplet = result instanceof Applet;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isApplet) {
                Beans.appletLoaded((Applet)result, classLoader, beanName, context, (AppletInitializer)initializer, deserialized);
            }
            if (null != context) {
                context.add(result);
            }
        }
        return result;
    }

    public static Object instantiate(ClassLoader loader, String name) throws IOException, ClassNotFoundException {
        return Beans.internalInstantiate(loader, name, null, null);
    }

    public static Object instantiate(ClassLoader cls, String beanName, BeanContext beanContext) throws IOException, ClassNotFoundException {
        return Beans.internalInstantiate(cls, beanName, beanContext, null);
    }

    public static Object instantiate(ClassLoader cls, String beanName, BeanContext context, AppletInitializer initializer) throws IOException, ClassNotFoundException {
        return Beans.internalInstantiate(cls, beanName, context, initializer);
    }

    public static Object getInstanceOf(Object bean, Class<?> targetType) {
        return bean;
    }

    public static boolean isInstanceOf(Object bean, Class<?> targetType) {
        if (bean == null) {
            throw new NullPointerException(Messages.getString("beans.1D"));
        }
        return targetType == null ? false : targetType.isInstance(bean);
    }

    public static synchronized void setGuiAvailable(boolean isGuiAvailable) throws SecurityException {
        Beans.checkPropertiesAccess();
        guiAvailable = isGuiAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDesignTime(boolean isDesignTime) throws SecurityException {
        Beans.checkPropertiesAccess();
        Class<Beans> clazz = Beans.class;
        synchronized (Beans.class) {
            designTime = isDesignTime;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized boolean isGuiAvailable() {
        return guiAvailable;
    }

    public static synchronized boolean isDesignTime() {
        return designTime;
    }

    private static void checkPropertiesAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
    }

    private static String getBeanResourceName(String beanName) {
        return beanName.replace('.', '/') + ".ser";
    }

    private static void appletLoaded(Applet applet, ClassLoader loader, String name, BeanContext context, AppletInitializer initializer, boolean deserialized) throws ClassNotFoundException {
        if (initializer != null) {
            initializer.initialize(applet, context);
        } else {
            Beans.setStub(applet, loader, deserialized, name);
        }
        if (!deserialized) {
            applet.init();
        }
        if (initializer != null) {
            initializer.activate(applet);
        }
    }

    private static void setStub(Applet applet, final ClassLoader loader, boolean serialized, String beanName) throws ClassNotFoundException {
        String pathName = beanName.replace('.', '/');
        final String resourceName = serialized ? pathName.concat(".ser") : pathName.concat(".class");
        URL objectUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                if (loader == null) {
                    return ClassLoader.getSystemResource(resourceName);
                }
                return loader.getResource(resourceName);
            }
        });
        if (objectUrl == null) {
            applet.setStub(Beans.getAppletStub(Beans.getStubAppletContext(applet), null, null));
            return;
        }
        String urlString = objectUrl.toExternalForm();
        int codeURLlength = urlString.length() - resourceName.length();
        URL codeBase = Beans.safeURL(urlString.substring(0, codeURLlength));
        int docURLlength = urlString.lastIndexOf(47);
        URL docBase = Beans.safeURL(urlString.substring(0, docURLlength + 1));
        applet.setStub(Beans.getAppletStub(Beans.getStubAppletContext(applet), codeBase, docBase));
    }

    private static AppletStub getAppletStub(final AppletContext context, final URL codeBase, final URL docBase) {
        return new AppletStub(){

            @Override
            public boolean isActive() {
                return true;
            }

            @Override
            public URL getDocumentBase() {
                return docBase;
            }

            @Override
            public URL getCodeBase() {
                return codeBase;
            }

            @Override
            public String getParameter(String name) {
                return null;
            }

            @Override
            public AppletContext getAppletContext() {
                return context;
            }

            @Override
            public void appletResize(int width, int height) {
            }
        };
    }

    private static AppletContext getStubAppletContext(final Applet target) {
        return new AppletContext(){

            @Override
            public AudioClip getAudioClip(URL url) {
                return null;
            }

            @Override
            public synchronized Image getImage(URL url) {
                return null;
            }

            @Override
            public Applet getApplet(String name) {
                return null;
            }

            @Override
            public Enumeration<Applet> getApplets() {
                Vector<Applet> applets = new Vector<Applet>();
                applets.addElement(target);
                return applets.elements();
            }

            @Override
            public void showDocument(URL url) {
            }

            @Override
            public void showDocument(URL url, String aTarget) {
            }

            @Override
            public void showStatus(String status) {
            }

            @Override
            public void setStream(String key, InputStream stream) throws IOException {
            }

            @Override
            public InputStream getStream(String key) {
                return null;
            }

            @Override
            public Iterator<String> getStreamKeys() {
                return null;
            }
        };
    }

    private static URL safeURL(String urlString) throws ClassNotFoundException {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException exception) {
            throw new ClassNotFoundException(exception.getMessage());
        }
    }
}

