/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans;

import com.googlecode.openbeans.PropertyChangeEvent;
import com.googlecode.openbeans.PropertyVetoException;
import com.googlecode.openbeans.VetoableChangeListener;
import com.googlecode.openbeans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class VetoableChangeSupport
implements Serializable {
    private static final long serialVersionUID = -5090210921595982017L;
    private Hashtable<String, VetoableChangeSupport> children = new Hashtable();
    private transient ArrayList<VetoableChangeListener> globalListeners = new ArrayList();
    private Object source;
    private int vetoableChangeSupportSerializedDataVersion = 2;

    public VetoableChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public synchronized void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        VetoableChangeSupport listeners;
        if (propertyName != null && listener != null && (listeners = this.children.get(propertyName)) != null) {
            listeners.removeVetoableChangeListener(listener);
        }
    }

    public synchronized void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (propertyName != null && listener != null) {
            VetoableChangeSupport listeners = this.children.get(propertyName);
            if (listeners == null) {
                listeners = new VetoableChangeSupport(this.source);
                this.children.put(propertyName, listeners);
            }
            listeners.addVetoableChangeListener(listener);
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        VetoableChangeSupport listeners = null;
        if (propertyName != null) {
            listeners = this.children.get(propertyName);
        }
        return listeners == null ? new VetoableChangeListener[]{} : VetoableChangeSupport.getAsVetoableChangeListenerArray(listeners);
    }

    public synchronized boolean hasListeners(String propertyName) {
        VetoableChangeSupport listeners;
        boolean result;
        boolean bl = result = this.globalListeners.size() > 0;
        if (!result && propertyName != null && (listeners = this.children.get(propertyName)) != null) {
            result = listeners.globalListeners.size() > 0;
        }
        return result;
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener != null) {
            this.globalListeners.remove(listener);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener != null) {
            if (listener instanceof VetoableChangeListenerProxy) {
                VetoableChangeListenerProxy proxy = (VetoableChangeListenerProxy)listener;
                this.addVetoableChangeListener(proxy.getPropertyName(), (VetoableChangeListener)proxy.getListener());
            } else {
                this.globalListeners.add(listener);
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        ArrayList<VetoableChangeListener> result = new ArrayList<VetoableChangeListener>();
        if (this.globalListeners != null) {
            result.addAll(this.globalListeners);
        }
        for (String propertyName : this.children.keySet()) {
            VetoableChangeSupport namedListener = this.children.get(propertyName);
            VetoableChangeListener[] childListeners = namedListener.getVetoableChangeListeners();
            for (int i = 0; i < childListeners.length; ++i) {
                result.add(new VetoableChangeListenerProxy(propertyName, childListeners[i]));
            }
        }
        return result.toArray(new VetoableChangeListener[result.size()]);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        VetoableChangeListener[] copy = new VetoableChangeListener[this.globalListeners.size()];
        this.globalListeners.toArray(copy);
        for (VetoableChangeListener listener : copy) {
            if (!(listener instanceof Serializable)) continue;
            oos.writeObject(listener);
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object listener;
        ois.defaultReadObject();
        this.globalListeners = new ArrayList();
        if (null == this.children) {
            this.children = new Hashtable();
        }
        do {
            listener = ois.readObject();
            this.addVetoableChangeListener((VetoableChangeListener)listener);
        } while (listener != null);
    }

    public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        PropertyChangeEvent event = this.createPropertyChangeEvent(propertyName, oldValue, newValue);
        this.doFirePropertyChange(event);
    }

    public void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        PropertyChangeEvent event = this.createPropertyChangeEvent(propertyName, oldValue, newValue);
        this.doFirePropertyChange(event);
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        PropertyChangeEvent event = this.createPropertyChangeEvent(propertyName, oldValue, newValue);
        this.doFirePropertyChange(event);
    }

    public void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        this.doFirePropertyChange(event);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        return new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFirePropertyChange(PropertyChangeEvent event) throws PropertyVetoException {
        String propName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (newValue != null && oldValue != null && newValue.equals(oldValue)) {
            return;
        }
        VetoableChangeSupport listeners = null;
        VetoableChangeListener[] vetoableChangeListenerArray = this;
        synchronized (this) {
            VetoableChangeListener[] listensToAll = this.globalListeners.toArray(new VetoableChangeListener[0]);
            String propertyName = event.getPropertyName();
            if (propertyName != null) {
                listeners = this.children.get(propertyName);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            try {
                for (VetoableChangeListener listener : listensToAll) {
                    listener.vetoableChange(event);
                }
            }
            catch (PropertyVetoException pve) {
                PropertyChangeEvent revertEvent = super.createPropertyChangeEvent(propName, newValue, oldValue);
                for (VetoableChangeListener listener : listensToAll) {
                    try {
                        listener.vetoableChange(revertEvent);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                throw pve;
            }
            if (listeners != null) {
                listeners.fireVetoableChange(event);
            }
            return;
        }
    }

    private static VetoableChangeListener[] getAsVetoableChangeListenerArray(VetoableChangeSupport listeners) {
        return listeners.globalListeners.toArray(new VetoableChangeListener[0]);
    }
}

