/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbeans.beancontext;

import com.googlecode.openbeans.beancontext.BeanContext;
import com.googlecode.openbeans.beancontext.BeanContextChild;
import com.googlecode.openbeans.beancontext.BeanContextServiceAvailableEvent;
import com.googlecode.openbeans.beancontext.BeanContextServiceProvider;
import com.googlecode.openbeans.beancontext.BeanContextServiceRevokedEvent;
import com.googlecode.openbeans.beancontext.BeanContextServiceRevokedListener;
import com.googlecode.openbeans.beancontext.BeanContextServices;
import com.googlecode.openbeans.beancontext.BeanContextServicesListener;
import com.googlecode.openbeans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;
import org.apache.harmony.beans.internal.nls.Messages;

public class BeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices,
Serializable {
    private static final long serialVersionUID = -8494482757288719206L;
    protected transient HashMap services;
    protected transient int serializable;
    protected transient BCSSProxyServiceProvider proxy;
    protected transient ArrayList bcsListeners;

    public BeanContextServicesSupport() {
    }

    public BeanContextServicesSupport(BeanContextServices peer) {
        super(peer);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale locale) {
        super(peer, locale);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale locale, boolean designTime) {
        super(peer, locale, designTime);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale locale, boolean designTime, boolean okToUseGui) {
        super(peer, locale, designTime, okToUseGui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextServicesListener(BeanContextServicesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.add(listener);
        }
    }

    @Override
    public boolean addService(Class serviceClass, BeanContextServiceProvider provider) {
        return this.addService(serviceClass, provider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addService(Class serviceClass, BeanContextServiceProvider provider, boolean fireEvent) {
        if (serviceClass == null || provider == null) {
            throw new NullPointerException();
        }
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                if (this.services.containsKey(serviceClass)) {
                    return false;
                }
                this.services.put(serviceClass, this.createBCSSServiceProvider(serviceClass, provider));
                if (provider instanceof Serializable) {
                    ++this.serializable;
                }
            }
        }
        if (fireEvent) {
            this.notifyServiceAvailable(new BeanContextServiceAvailableEvent(this, serviceClass));
        }
        return true;
    }

    private void notifyServiceAvailable(BeanContextServiceAvailableEvent event) {
        this.fireServiceAdded(event);
        Object[] childs = this.copyChildren();
        for (int i = 0; i < childs.length; ++i) {
            if (!(childs[i] instanceof BeanContextServices)) continue;
            ((BeanContextServices)childs[i]).serviceAvailable(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void bcsPreDeserializationHook(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        super.bcsPreDeserializationHook(ois);
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            this.serializable = ois.readInt();
            for (int i = 0; i < this.serializable; ++i) {
                Object serviceClass = ois.readObject();
                Object bcssProvider = ois.readObject();
                this.services.put((Class)serviceClass, (BCSSServiceProvider)bcssProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void bcsPreSerializationHook(ObjectOutputStream oos) throws IOException {
        super.bcsPreSerializationHook(oos);
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            oos.writeInt(this.serializable);
            for (Map.Entry entry : this.services.entrySet()) {
                if (!(((BCSSServiceProvider)entry.getValue()).getServiceProvider() instanceof Serializable)) continue;
                oos.writeObject(entry.getKey());
                oos.writeObject(entry.getValue());
            }
        }
    }

    @Override
    protected void childJustRemovedHook(Object child, BeanContextSupport.BCSChild bcsChild) {
        if (bcsChild instanceof BCSSChild) {
            this.releaseServicesForChild((BCSSChild)bcsChild, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseServicesForChild(BCSSChild bcssChild, boolean delegatedServices) {
        if (bcssChild.serviceRecords == null || bcssChild.serviceRecords.isEmpty()) {
            return;
        }
        Object object = bcssChild.child;
        synchronized (object) {
            Object[] records = bcssChild.serviceRecords.toArray();
            for (int i = 0; i < records.length; ++i) {
                ServiceRecord rec = (ServiceRecord)records[i];
                if (delegatedServices) {
                    if (!rec.isDelegate) continue;
                    this.releaseServiceWithoutCheck(rec.child, bcssChild, rec.requestor, rec.service, true);
                    continue;
                }
                this.releaseServiceWithoutCheck(rec.child, bcssChild, rec.requestor, rec.service, false);
            }
        }
    }

    @Override
    protected BeanContextSupport.BCSChild createBCSChild(Object child, Object proxyPeer) {
        return new BCSSChild(child, proxyPeer);
    }

    protected BCSSServiceProvider createBCSSServiceProvider(Class serviceClass, BeanContextServiceProvider provider) {
        return new BCSSServiceProvider(provider);
    }

    protected final void fireServiceAdded(Class serviceClass) {
        this.fireServiceAdded(new BeanContextServiceAvailableEvent(this, serviceClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceAdded(BeanContextServiceAvailableEvent event) {
        Object[] listeners;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            listeners = this.bcsListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            BeanContextServicesListener l = (BeanContextServicesListener)listeners[i];
            l.serviceAvailable(event);
        }
    }

    protected final void fireServiceRevoked(Class serviceClass, boolean revokeNow) {
        this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, serviceClass, revokeNow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent event) {
        Object[] listeners;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            listeners = this.bcsListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            BeanContextServicesListener l = (BeanContextServicesListener)listeners[i];
            l.serviceRevoked(event);
        }
    }

    public BeanContextServices getBeanContextServicesPeer() {
        return (BeanContextServices)this.beanContextChildPeer;
    }

    protected static final BeanContextServicesListener getChildBeanContextServicesListener(Object child) {
        if (child instanceof BeanContextServicesListener) {
            return (BeanContextServicesListener)child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getCurrentServiceClasses() {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            return new BeanContextSupport.BCSIterator(this.services.keySet().iterator());
        }
    }

    @Override
    public Iterator getCurrentServiceSelectors(Class serviceClass) {
        BeanContextServiceProvider provider = this.getLocalServiceProvider(serviceClass);
        return provider == null ? null : new BeanContextSupport.BCSIterator(provider.getCurrentServiceSelectors(this.getBeanContextServicesPeer(), serviceClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanContextServiceProvider getLocalServiceProvider(Class serviceClass) {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            BCSSServiceProvider bcssProvider = (BCSSServiceProvider)this.services.get(serviceClass);
            if (bcssProvider != null) {
                return bcssProvider.getServiceProvider();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getService(BeanContextChild child, Object requestor, Class serviceClass, Object serviceSelector, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
        if (child == null || requestor == null || serviceClass == null || bcsrl == null) {
            throw new NullPointerException();
        }
        BCSSChild bcssChild = null;
        BeanContextServiceProvider provider = null;
        Object service = null;
        boolean isDelegate = false;
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                bcssChild = (BCSSChild)this.children.get(child);
            }
            if (bcssChild == null) {
                throw new IllegalArgumentException(Messages.getString("beans.65"));
            }
            provider = this.getLocalServiceProvider(serviceClass);
            if (provider != null) {
                service = provider.getService(this.getBeanContextServicesPeer(), requestor, serviceClass, serviceSelector);
            }
            if (service == null && this.proxy != null) {
                provider = this.proxy;
                service = this.proxy.getService(this.getBeanContextServicesPeer(), requestor, serviceClass, serviceSelector, bcsrl);
                isDelegate = true;
            }
        }
        if (service != null) {
            object = child;
            synchronized (object) {
                if (bcssChild.serviceRecords == null) {
                    bcssChild.serviceRecords = new ArrayList();
                }
                bcssChild.serviceRecords.add(new ServiceRecord(provider, child, requestor, serviceClass, bcsrl, service, isDelegate));
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasService(Class serviceClass) {
        boolean has;
        if (serviceClass == null) {
            throw new NullPointerException();
        }
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            has = this.services.containsKey(serviceClass);
        }
        if (!has && this.getBeanContext() instanceof BeanContextServices) {
            has = ((BeanContextServices)this.getBeanContext()).hasService(serviceClass);
        }
        return has;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.services = new HashMap();
        this.serializable = 0;
        this.proxy = null;
        this.bcsListeners = new ArrayList();
    }

    @Override
    protected void initializeBeanContextResources() {
        super.initializeBeanContextResources();
        BeanContext context = this.getBeanContext();
        this.proxy = context instanceof BeanContextServices ? new BCSSProxyServiceProvider((BeanContextServices)context) : null;
    }

    @Override
    protected void releaseBeanContextResources() {
        super.releaseBeanContextResources();
        this.releaseAllDelegatedServices();
        this.proxy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllDelegatedServices() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iter = this.bcsChildren();
            while (iter.hasNext()) {
                this.releaseServicesForChild((BCSSChild)iter.next(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseService(BeanContextChild child, Object requestor, Object service) {
        if (child == null || requestor == null || service == null) {
            throw new NullPointerException();
        }
        Object object = globalHierarchyLock;
        synchronized (object) {
            BCSSChild bcssChild;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                bcssChild = (BCSSChild)this.children.get(child);
            }
            if (bcssChild == null) {
                throw new IllegalArgumentException(Messages.getString("beans.65"));
            }
            this.releaseServiceWithoutCheck(child, bcssChild, requestor, service, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseServiceWithoutCheck(BeanContextChild child, BCSSChild bcssChild, Object requestor, Object service, boolean callRevokedListener) {
        if (bcssChild.serviceRecords == null || bcssChild.serviceRecords.isEmpty()) {
            return;
        }
        BeanContextChild beanContextChild = child;
        synchronized (beanContextChild) {
            Iterator<ServiceRecord> iter = bcssChild.serviceRecords.iterator();
            while (iter.hasNext()) {
                ServiceRecord rec = iter.next();
                if (rec.requestor != requestor || rec.service != service) continue;
                rec.provider.releaseService(this.getBeanContextServicesPeer(), requestor, service);
                if (callRevokedListener && rec.revokedListener != null) {
                    rec.revokedListener.serviceRevoked(new BeanContextServiceRevokedEvent(this.getBeanContextServicesPeer(), rec.serviceClass, true));
                }
                iter.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextServicesListener(BeanContextServicesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeService(Class serviceClass, BeanContextServiceProvider serviceProvider, boolean revokeCurrentServicesNow) {
        if (serviceClass == null || serviceProvider == null) {
            throw new NullPointerException();
        }
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.services;
            synchronized (hashMap) {
                BCSSServiceProvider bcssProvider = (BCSSServiceProvider)this.services.get(serviceClass);
                if (bcssProvider == null) {
                    return;
                }
                if (bcssProvider.getServiceProvider() != serviceProvider) {
                    throw new IllegalArgumentException(Messages.getString("beans.66"));
                }
                this.services.remove(serviceClass);
                if (serviceProvider instanceof Serializable) {
                    --this.serializable;
                }
            }
        }
        this.fireServiceRevoked(serviceClass, revokeCurrentServicesNow);
        this.notifyServiceRevokedToServiceUsers(serviceClass, serviceProvider, revokeCurrentServicesNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceRevokedToServiceUsers(Class serviceClass, BeanContextServiceProvider serviceProvider, boolean revokeCurrentServicesNow) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iter = this.bcsChildren();
            while (iter.hasNext()) {
                BCSSChild bcssChild = (BCSSChild)iter.next();
                this.notifyServiceRevokedToServiceUsers(serviceClass, serviceProvider, revokeCurrentServicesNow, bcssChild);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceRevokedToServiceUsers(Class serviceClass, BeanContextServiceProvider serviceProvider, boolean revokeCurrentServicesNow, BCSSChild bcssChild) {
        if (bcssChild.serviceRecords == null || bcssChild.serviceRecords.isEmpty()) {
            return;
        }
        Object object = bcssChild.child;
        synchronized (object) {
            for (ServiceRecord rec : bcssChild.serviceRecords) {
                if (rec.serviceClass != serviceClass || rec.provider != serviceProvider || rec.revokedListener == null || rec.isDelegate) continue;
                rec.revokedListener.serviceRevoked(new BeanContextServiceRevokedEvent(this.getBeanContextServicesPeer(), serviceClass, revokeCurrentServicesNow));
                rec.revokedListener = null;
            }
        }
    }

    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent event) {
        if (null == event) {
            throw new NullPointerException(Messages.getString("beans.1C"));
        }
        if (this.services.containsKey(event.serviceClass)) {
            return;
        }
        this.fireServiceAdded(event);
        Object[] childs = this.copyChildren();
        for (int i = 0; i < childs.length; ++i) {
            if (!(childs[i] instanceof BeanContextServices)) continue;
            ((BeanContextServices)childs[i]).serviceAvailable(event);
        }
    }

    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent event) {
        if (null == event) {
            throw new NullPointerException(Messages.getString("beans.1C"));
        }
        if (this.services.containsKey(event.serviceClass)) {
            return;
        }
        this.fireServiceRevoked(event);
        Object[] childs = this.copyChildren();
        for (int i = 0; i < childs.length; ++i) {
            if (!(childs[i] instanceof BeanContextServices)) continue;
            ((BeanContextServices)childs[i]).serviceRevoked(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.serialize(oos, this.bcsListeners);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.deserialize(ois, this.bcsListeners);
    }

    protected static class BCSSServiceProvider
    implements Serializable {
        private static final long serialVersionUID = 861278251667444782L;
        protected BeanContextServiceProvider serviceProvider;

        BCSSServiceProvider(BeanContextServiceProvider provider) {
            this.serviceProvider = provider;
        }

        protected BeanContextServiceProvider getServiceProvider() {
            return this.serviceProvider;
        }
    }

    private class ServiceRevokedListenerDelegator
    implements BeanContextServiceRevokedListener {
        private BeanContextServiceRevokedListener backListener;

        public ServiceRevokedListenerDelegator(BeanContextServiceRevokedListener backListener) {
            this.backListener = backListener;
        }

        @Override
        public void serviceRevoked(BeanContextServiceRevokedEvent event) {
            this.backListener.serviceRevoked(new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), event.getServiceClass(), event.isCurrentServiceInvalidNow()));
        }
    }

    protected class BCSSProxyServiceProvider
    implements BeanContextServiceProvider,
    BeanContextServiceRevokedListener {
        private BeanContextServices backBCS;

        BCSSProxyServiceProvider(BeanContextServices backBCS) {
            this.backBCS = backBCS;
        }

        @Override
        public Iterator getCurrentServiceSelectors(BeanContextServices bcs, Class serviceClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getService(BeanContextServices bcs, Object requestor, Class serviceClass, Object serviceSelector) {
            throw new UnsupportedOperationException();
        }

        Object getService(BeanContextServices bcs, Object requestor, Class serviceClass, Object serviceSelector, BeanContextServiceRevokedListener listener) throws TooManyListenersException {
            return this.backBCS.getService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), requestor, serviceClass, serviceSelector, new ServiceRevokedListenerDelegator(listener));
        }

        @Override
        public void releaseService(BeanContextServices bcs, Object requestor, Object service) {
            this.backBCS.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), requestor, service);
        }

        @Override
        public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
            throw new UnsupportedOperationException();
        }
    }

    protected class BCSSChild
    extends BeanContextSupport.BCSChild {
        private static final long serialVersionUID = -3263851306889194873L;
        transient ArrayList<ServiceRecord> serviceRecords;

        BCSSChild(Object child, Object proxyPeer) {
            super(BeanContextServicesSupport.this, child, proxyPeer);
        }
    }

    private static class ServiceRecord {
        BeanContextServiceProvider provider;
        BeanContextChild child;
        Object requestor;
        Class serviceClass;
        BeanContextServiceRevokedListener revokedListener;
        Object service;
        boolean isDelegate;

        ServiceRecord(BeanContextServiceProvider provider, BeanContextChild child, Object requestor, Class serviceClass, BeanContextServiceRevokedListener revokedListener, Object service, boolean isDelegate) {
            this.provider = provider;
            this.child = child;
            this.requestor = requestor;
            this.serviceClass = serviceClass;
            this.revokedListener = revokedListener;
            this.service = service;
            this.isDelegate = isDelegate;
        }
    }
}

