/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.editors;

import com.googlecode.openbeans.PropertyChangeEvent;
import com.googlecode.openbeans.PropertyChangeListener;
import com.googlecode.openbeans.PropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class ColorEditor
extends Panel
implements PropertyEditor {
    List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private Color value;
    private Object source;

    public ColorEditor(Object source) {
        if (null == source) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    public ColorEditor() {
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getJavaInitializationString() {
        Color value = (Color)this.getValue();
        if (value != null) {
            StringBuilder sb = new StringBuilder("new java.awt.Color(");
            sb.append(value.getRed());
            sb.append(',');
            sb.append(value.getGreen());
            sb.append(',');
            sb.append(value.getBlue() + ")");
            return sb.toString();
        }
        return null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setValue(Object value) {
        PropertyChangeListener[] copy;
        if (null == value) {
            return;
        }
        Color oldValue = this.value;
        this.value = (Color)value;
        PropertyChangeEvent changeAllEvent = new PropertyChangeEvent(this, "value", oldValue, value);
        for (PropertyChangeListener listener : copy = this.listeners.toArray(new PropertyChangeListener[0])) {
            listener.propertyChange(changeAllEvent);
        }
    }

    @Override
    public String getAsText() {
        Color value = (Color)this.getValue();
        if (value != null) {
            StringBuilder sb = new StringBuilder(14);
            sb.append(value.getRed());
            sb.append(',');
            sb.append(value.getGreen());
            sb.append(',');
            sb.append(value.getBlue());
            return sb.toString();
        }
        return "";
    }

    @Override
    public void setAsText(String text) {
        if (null == text) {
            throw new NullPointerException();
        }
        String aText = text;
        try {
            int commaIndex = aText.indexOf(44);
            int red = Integer.parseInt(aText.substring(0, commaIndex));
            aText = aText.substring(commaIndex + 1);
            commaIndex = aText.indexOf(44);
            int green = Integer.parseInt(aText.substring(0, commaIndex));
            aText = aText.substring(commaIndex + 1);
            int blue = Integer.parseInt(aText);
            this.setValue(new Color(red, green, blue));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(aText);
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        Color color = (Color)this.getValue();
        if (color != null) {
            gfx.setColor(color);
            gfx.drawRect(box.x, box.y, box.x + box.width, box.y + box.height);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> copy = new ArrayList<PropertyChangeListener>(this.listeners.size());
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            copy.addAll(this.listeners);
        }
        PropertyChangeEvent changeAllEvent = new PropertyChangeEvent(this.source, null, null, null);
        for (PropertyChangeListener listna : copy) {
            listna.propertyChange(changeAllEvent);
        }
    }
}

