/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.RandomString;

public class CachedReturnPlugin
extends Plugin.ForElementMatcher {
    private static final String NAME_INFIX = "_";
    private final RandomString randomString = new RandomString();

    public CachedReturnPlugin() {
        super(ElementMatchers.declaresMethod(ElementMatchers.isAnnotatedWith(Enhance.class)));
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription) {
        for (MethodDescription.InDefinedShape methodDescription : (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isAnnotatedWith(Enhance.class))) {
            Class advice;
            if (methodDescription.isAbstract()) {
                throw new IllegalStateException("Cannot cache the value of an abstract method: " + methodDescription);
            }
            if (!methodDescription.getParameters().isEmpty()) {
                throw new IllegalStateException("Cannot cache the value of a method with parameters: " + methodDescription);
            }
            String name = methodDescription.getDeclaredAnnotations().ofType(Enhance.class).loadSilent().value();
            if (name.isEmpty()) {
                name = methodDescription.getName() + NAME_INFIX + this.randomString.nextString();
            }
            if (!methodDescription.getReturnType().isPrimitive()) {
                advice = ReferenceAdvice.class;
            } else if (methodDescription.getReturnType().represents(Boolean.TYPE)) {
                advice = BooleanAdvice.class;
            } else if (methodDescription.getReturnType().represents(Byte.TYPE)) {
                advice = ByteAdvice.class;
            } else if (methodDescription.getReturnType().represents(Short.TYPE)) {
                advice = ShortAdvice.class;
            } else if (methodDescription.getReturnType().represents(Character.TYPE)) {
                advice = CharacterAdvice.class;
            } else if (methodDescription.getReturnType().represents(Integer.TYPE)) {
                advice = IntegerAdvice.class;
            } else if (methodDescription.getReturnType().represents(Long.TYPE)) {
                advice = LongAdvice.class;
            } else if (methodDescription.getReturnType().represents(Float.TYPE)) {
                advice = FloatAdvice.class;
            } else if (methodDescription.getReturnType().represents(Double.TYPE)) {
                advice = DoubleAdvice.class;
            } else {
                throw new IllegalStateException("Cannot cache a method that returns void: " + methodDescription);
            }
            builder = builder.defineField(name, (TypeDefinition)methodDescription.getReturnType().asErasure(), methodDescription.isStatic() ? Ownership.STATIC : Ownership.MEMBER, Visibility.PRIVATE, SyntheticState.SYNTHETIC).visit(Advice.withCustomMapping().bind(CacheField.class, new CacheFieldOffsetMapping(name)).to(advice).on(ElementMatchers.is(methodDescription)));
        }
        return builder;
    }

    private static class ReferenceAdvice {
        private ReferenceAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static Object enter(@CacheField Object cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @CacheField Object cached) {
            if (returned == null) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class DoubleAdvice {
        private DoubleAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static double enter(@CacheField double cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) double returned, @CacheField double cached) {
            if (returned == 0.0) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class FloatAdvice {
        private FloatAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static float enter(@CacheField float cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) float returned, @CacheField float cached) {
            if (returned == 0.0f) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class LongAdvice {
        private LongAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static long enter(@CacheField long cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) long returned, @CacheField long cached) {
            if (returned == 0L) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class IntegerAdvice {
        private IntegerAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static int enter(@CacheField int cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) int returned, @CacheField int cached) {
            if (returned == 0) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class CharacterAdvice {
        private CharacterAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static char enter(@CacheField char cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) char returned, @CacheField char cached) {
            if (returned == '\u0000') {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class ShortAdvice {
        private ShortAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static short enter(@CacheField short cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) short returned, @CacheField short cached) {
            if (returned == 0) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class ByteAdvice {
        private ByteAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static byte enter(@CacheField byte cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) byte returned, @CacheField byte cached) {
            if (returned == 0) {
                returned = cached;
            } else {
                cached = returned;
            }
        }
    }

    private static class BooleanAdvice {
        private BooleanAdvice() {
            throw new UnsupportedOperationException("This class is merely an advice template and should not be instantiated");
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        protected static boolean enter(@CacheField boolean cached) {
            return cached;
        }

        @Advice.OnMethodExit
        protected static void exit(@Advice.Return(readOnly=false) boolean returned, @CacheField boolean cached) {
            if (returned) {
                cached = true;
            } else {
                returned = true;
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class CacheFieldOffsetMapping
    implements Advice.OffsetMapping {
        private final String name;

        protected CacheFieldOffsetMapping(String name) {
            this.name = name;
        }

        @Override
        public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
            return new Advice.OffsetMapping.Target.ForField.ReadWrite((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.name.equals(((CacheFieldOffsetMapping)object).name);
        }

        public int hashCode() {
            return 17 * 31 + this.name.hashCode();
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CacheField {
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public String value() default "";
    }
}

