/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import com.github.javaparser.JavaParser;
import com.github.javaparser.JavaToken;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Position;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import com.github.javaparser.javadoc.description.JavadocSnippet;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.revelc.code.impsort.Grouper;
import net.revelc.code.impsort.Import;
import net.revelc.code.impsort.LineEnding;
import net.revelc.code.impsort.Result;
import net.revelc.code.impsort.ex.ImpSortException;

public class ImpSort {
    private static final Comparator<Node> BY_POSITION = Comparator.comparing(a -> (Position)a.getBegin().get());
    private final Charset sourceEncoding;
    private final Grouper grouper;
    private final boolean removeUnused;
    private final boolean treatSamePackageAsUnused;
    private final LineEnding lineEnding;
    private final ParserConfiguration.LanguageLevel languageLevel;

    public ImpSort(Charset sourceEncoding, Grouper grouper, boolean removeUnused, boolean treatSamePackageAsUnused, LineEnding lineEnding) {
        this(sourceEncoding, grouper, removeUnused, treatSamePackageAsUnused, lineEnding, ParserConfiguration.LanguageLevel.POPULAR);
    }

    public ImpSort(Charset sourceEncoding, Grouper grouper, boolean removeUnused, boolean treatSamePackageAsUnused, LineEnding lineEnding, ParserConfiguration.LanguageLevel languageLevel) {
        this.sourceEncoding = sourceEncoding;
        this.grouper = grouper;
        this.removeUnused = removeUnused;
        this.treatSamePackageAsUnused = treatSamePackageAsUnused;
        this.lineEnding = lineEnding;
        this.languageLevel = languageLevel;
    }

    private static List<String> readAllLines(String str) {
        ArrayList<String> result = new ArrayList<String>();
        try (Scanner s = new Scanner(str);){
            while (s.hasNextLine()) {
                result.add(s.nextLine());
            }
        }
        return result;
    }

    public Result parseFile(Path path) throws IOException {
        byte[] buf = Files.readAllBytes(path);
        return this.parseFile(path, buf);
    }

    public Result parseFile(Path path, byte[] buf) throws IOException {
        int start;
        LineEnding impLineEnding;
        if (buf == null || buf.length == 0) {
            return Result.EMPTY_FILE;
        }
        String file = new String(buf, this.sourceEncoding);
        LineEnding fileLineEnding = LineEnding.determineLineEnding(file);
        if (this.lineEnding == LineEnding.KEEP) {
            if (fileLineEnding == LineEnding.UNKNOWN) {
                throw new ImpSortException(path, ImpSortException.Reason.UNKNOWN_LINE_ENDING);
            }
            impLineEnding = fileLineEnding;
        } else {
            impLineEnding = this.lineEnding;
        }
        List<String> fileLines = ImpSort.readAllLines(file);
        ParseResult parseResult = new JavaParser(new ParserConfiguration().setLanguageLevel(this.languageLevel)).parse(file);
        CompilationUnit unit = (CompilationUnit)parseResult.getResult().orElseThrow(() -> new ImpSortException(path, ImpSortException.Reason.UNABLE_TO_PARSE));
        if (!parseResult.isSuccessful()) {
            parseResult.getProblems().forEach(System.out::println);
            throw new ImpSortException(path, ImpSortException.Reason.PARTIAL_PARSE);
        }
        Position packagePosition = unit.getPackageDeclaration().map(p -> (Position)p.getEnd().get()).orElse((Position)unit.getBegin().get());
        NodeList importDeclarations = unit.getImports();
        if (importDeclarations.isEmpty()) {
            return new Result(path, this.sourceEncoding, fileLines, 0, fileLines.size(), "", "", Collections.emptyList(), impLineEnding);
        }
        Position lastImportPosition = (Position)((ImportDeclaration)importDeclarations.stream().max(BY_POSITION).get()).getBegin().get();
        Stream<Comment> orphanedComments = unit.getOrphanComments().parallelStream().filter(c -> {
            Position p = (Position)c.getBegin().get();
            return p.isAfter(packagePosition) && p.isBefore(lastImportPosition);
        });
        List<Node> importSectionNodes = Stream.concat(orphanedComments, importDeclarations.stream()).collect(Collectors.toList());
        importSectionNodes.sort(BY_POSITION);
        Node firstImport = (Node)importSectionNodes.get(0);
        int stop = ((Position)((Node)importSectionNodes.get((int)(importSectionNodes.size() - 1))).getEnd().get()).line;
        for (start = firstImport.getComment().map((Function<Comment, Position>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseFile$4(com.github.javaparser.ast.comments.Comment ), (Lcom/github/javaparser/ast/comments/Comment;)Lcom/github/javaparser/Position;)()).orElse((Position)((Position)firstImport.getBegin().get())).line - 1; start > 0 && fileLines.get(start - 1).trim().isEmpty(); --start) {
        }
        while (stop < fileLines.size() && fileLines.get(stop).trim().isEmpty()) {
            ++stop;
        }
        String originalSection = String.join((CharSequence)impLineEnding.getChars(), fileLines.subList(start, stop)) + impLineEnding.getChars();
        Set<Import> allImports = ImpSort.convertImportSection(importSectionNodes, impLineEnding.getChars());
        if (this.removeUnused) {
            ImpSort.removeUnusedImports(allImports, ImpSort.tokensInUse(unit));
            if (this.treatSamePackageAsUnused) {
                ImpSort.removeSamePackageImports(allImports, unit.getPackageDeclaration());
            }
        }
        Object newSection = this.grouper.groupedImports(allImports, impLineEnding.getChars());
        if (start > 0) {
            newSection = impLineEnding.getChars() + (String)newSection;
        }
        if (stop < fileLines.size()) {
            newSection = (String)newSection + impLineEnding.getChars();
        }
        return new Result(path, this.sourceEncoding, fileLines, start, stop, originalSection, (String)newSection, allImports, impLineEnding);
    }

    private static Set<Import> convertImportSection(List<Node> importSectionNodes, String eol) {
        ArrayList<Comment> recentComments = new ArrayList<Comment>();
        LinkedHashSet<Import> allImports = new LinkedHashSet<Import>(importSectionNodes.size() / 2);
        for (Node node : importSectionNodes) {
            if (node instanceof Comment) {
                recentComments.add((Comment)node);
                continue;
            }
            if (node instanceof ImportDeclaration) {
                ArrayList<Node> thisImport = new ArrayList<Node>(2);
                ImportDeclaration impDecl = (ImportDeclaration)node;
                thisImport.addAll(recentComments);
                Optional impComment = impDecl.getComment();
                if (impComment.isPresent()) {
                    Comment c = (Comment)impComment.get();
                    if (((Position)c.getBegin().get()).isBefore((Position)impDecl.getBegin().get())) {
                        thisImport.add((Node)c);
                        thisImport.add((Node)impDecl);
                    } else {
                        thisImport.add((Node)impDecl);
                        thisImport.add((Node)c);
                    }
                } else {
                    thisImport.add((Node)impDecl);
                }
                recentComments.clear();
                ImpSort.convertAndAddImport(allImports, thisImport, eol);
                continue;
            }
            throw new IllegalStateException("Unknown node: " + node);
        }
        if (!recentComments.isEmpty()) {
            throw new IllegalStateException("Unexpectedly found more orphaned comments: " + recentComments);
        }
        return allImports;
    }

    private static void convertAndAddImport(LinkedHashSet<Import> allImports, List<Node> thisImport, String eol) {
        boolean isStatic = false;
        String importItem = null;
        Object prefix = "";
        Object suffix = "";
        for (Node n : thisImport) {
            if (n instanceof Comment) {
                if (importItem == null) {
                    prefix = (String)prefix + n.toString();
                } else {
                    suffix = (String)suffix + n.toString();
                }
            }
            if (!(n instanceof ImportDeclaration)) continue;
            ImportDeclaration i = (ImportDeclaration)n;
            isStatic = i.isStatic();
            importItem = i.getName().asString() + (i.isAsterisk() ? ".*" : "");
        }
        if (!((String)(suffix = ((String)suffix).trim())).isEmpty()) {
            suffix = " " + (String)suffix;
        }
        Import imp = new Import(isStatic, importItem, ((String)prefix).trim(), (String)suffix, eol);
        Iterator iter = allImports.iterator();
        while (iter.hasNext()) {
            Import candidate = (Import)iter.next();
            if (!candidate.isDuplicatedBy(imp)) continue;
            iter.remove();
            imp = candidate.combineWith(imp);
        }
        allImports.add(imp);
    }

    private static Set<String> tokensInUse(CompilationUnit unit) {
        Stream packageDecl = unit.getPackageDeclaration().isPresent() ? Stream.of((PackageDeclaration)unit.getPackageDeclaration().get()).map(PackageDeclaration::getAnnotations).flatMap(Collection::stream) : Stream.empty();
        Stream<String> typesInCode = Stream.concat(packageDecl, unit.getTypes().stream()).map(Node::getTokenRange).filter(Optional::isPresent).map(Optional::get).filter(r -> r != TokenRange.INVALID).flatMap(r -> StreamSupport.stream(r.spliterator(), false)).map(JavaToken::asString);
        Stream typesInJavadocs = unit.getAllComments().stream().filter(c -> c instanceof JavadocComment).map(JavadocComment.class::cast).map(JavadocComment::parse).flatMap(ImpSort::parseJavadoc);
        return Stream.concat(typesInCode, typesInJavadocs).filter(t -> t != null && !t.isEmpty() && Character.isJavaIdentifierStart(t.charAt(0))).collect(Collectors.toSet());
    }

    private static Stream<String> parseJavadoc(Javadoc javadoc) {
        Stream stringsFromJavadocDescription = Stream.of(javadoc.getDescription()).flatMap(ImpSort::parseJavadocDescription);
        Stream stringsFromBlockTags = javadoc.getBlockTags().stream().flatMap(tag -> {
            EnumSet<JavadocBlockTag.Type> blockTagTypesWithImportableNames = EnumSet.of(JavadocBlockTag.Type.THROWS, JavadocBlockTag.Type.EXCEPTION);
            Stream importableTagNames = blockTagTypesWithImportableNames.contains(tag.getType()) ? Stream.of(tag.getName()).filter(Optional::isPresent).map(Optional::get) : Stream.empty();
            Stream tagDescriptions = Stream.of(tag.getContent()).flatMap(ImpSort::parseJavadocDescription);
            return Stream.concat(importableTagNames, tagDescriptions);
        });
        return Stream.concat(stringsFromJavadocDescription, stringsFromBlockTags);
    }

    private static Stream<String> parseJavadocDescription(JavadocDescription description) {
        return description.getElements().stream().map(element -> {
            if (element instanceof JavadocInlineTag) {
                return ((JavadocInlineTag)element).getContent();
            }
            if (element instanceof JavadocSnippet) {
                return element.toText();
            }
            return element.toText();
        }).flatMap(s -> Stream.of(s.split("\\W+")));
    }

    private static void removeUnusedImports(Set<Import> imports, Set<String> tokensInUse) {
        imports.removeIf(i -> {
            String[] segments = i.getImport().split("[.]");
            if (segments.length == 0) {
                throw new AssertionError((Object)"Parse tree includes invalid import statements");
            }
            String lastSegment = segments[segments.length - 1];
            if (lastSegment.equals("*")) {
                return false;
            }
            return !tokensInUse.contains(lastSegment);
        });
    }

    static void removeSamePackageImports(Set<Import> imports, Optional<PackageDeclaration> packageDeclaration) {
        String packageName = packageDeclaration.map(p -> p.getName().toString()).orElse("");
        imports.removeIf(i -> {
            String imp = i.getImport();
            if (packageName.isEmpty()) {
                return !imp.contains(".");
            }
            return imp.startsWith(packageName) && imp.lastIndexOf(".") <= packageName.length();
        });
    }

    private static /* synthetic */ Position lambda$parseFile$4(Comment c) {
        return (Position)c.getBegin().get();
    }
}

