/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmdLineOption {
    private List<String> options = new ArrayList<String>();
    private List<Boolean> hasArgs = new ArrayList<Boolean>();
    private List<String> descriptions = new ArrayList<String>();
    private Map<String, List<String>> optionsMap = new HashMap<String, List<String>>();

    public CmdLineOption addOption(String opt, boolean hasArg, String description) {
        if (!this.options.contains(opt = CmdLineOption.resolveOption(opt))) {
            this.options.add(opt);
            this.hasArgs.add(hasArg);
            this.descriptions.add(description);
        }
        return this;
    }

    public CmdLineOption parse(String[] arguments) {
        int optIndex = -1;
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if (arg.startsWith("-") || arg.startsWith("--")) {
                String lastOption;
                arg = CmdLineOption.resolveOption(arg);
                if (optIndex > -1 && this.hasArgs.get(optIndex).booleanValue() && this.optionsMap.get(lastOption = this.options.get(optIndex)).size() == 0) {
                    throw new IllegalArgumentException("Missing argument for option: " + lastOption);
                }
                optIndex = this.options.indexOf(arg);
                if (optIndex < 0) {
                    throw new IllegalArgumentException("Unrecognized option: " + arguments[i]);
                }
                this.optionsMap.put(arg, new ArrayList());
                continue;
            }
            if (optIndex <= -1) continue;
            String option = this.options.get(optIndex);
            this.optionsMap.get(option).add(arg);
        }
        return this;
    }

    public String getOptionValue(String opt) {
        return this.getOptionValue(opt, null);
    }

    public String getOptionValue(String opt, String dv) {
        String[] values = this.getOptionValues(opt);
        return values == null ? dv : values[0];
    }

    public String[] getOptionValues(String opt) {
        List<String> values = this.optionsMap.get(CmdLineOption.resolveOption(opt));
        return values == null || values.isEmpty() ? null : values.toArray(new String[values.size()]);
    }

    public boolean hasOption(String opt) {
        return this.optionsMap.keySet().contains(CmdLineOption.resolveOption(opt));
    }

    private static String resolveOption(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("--")) {
            return str.substring(2, str.length());
        }
        if (str.startsWith("-")) {
            return str.substring(1, str.length());
        }
        return str;
    }
}

