/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.extract.extractors;

import java.util.List;
import net.sf.composite.extract.ComponentAccessor;
import net.sf.composite.extract.ComponentAccessorException;
import net.sf.composite.util.Assert;
import net.sf.composite.util.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseComponentAccessor
implements ComponentAccessor {
    protected final Log log = LogFactory.getLog(this.getClass());

    protected abstract List getComponentsImpl(Object var1) throws Exception;

    public final List getComponents(Object composite) {
        Assert.notNull(composite, "composite");
        try {
            List components = this.getComponentsImpl(composite);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Extracted components " + ObjectUtils.getObjectDescription(components) + " from composite " + ObjectUtils.getObjectDescription(composite)));
            }
            return components;
        }
        catch (ComponentAccessorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentAccessorException("Unable to extract components of composite " + ObjectUtils.getObjectDescription(composite), e);
        }
    }

    protected abstract void setComponentsImpl(Object var1, List var2) throws Exception;

    public final void setComponents(Object composite, List components) throws ComponentAccessorException {
        Assert.notNull(composite, "composite");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Setting components of composite " + ObjectUtils.getObjectDescription(composite) + " to " + ObjectUtils.getObjectDescription(components)));
        }
        try {
            this.setComponentsImpl(composite, components);
        }
        catch (ComponentAccessorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentAccessorException("Unable to set components of composite " + ObjectUtils.getObjectDescription(composite) + " to " + ObjectUtils.getObjectDescription(components), e);
        }
    }
}

