/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.extract.extractors;

import java.lang.reflect.Method;
import net.sf.composite.extract.ComponentAccessorException;
import net.sf.composite.extract.extractors.BaseComponentAccessor;
import net.sf.composite.util.ObjectUtils;
import net.sf.composite.util.StringUtils;

public abstract class BasePropertyComponentAccessor
extends BaseComponentAccessor {
    private static final String DEFAULT_COMPONENT_PROPERTY = "components";
    private String componentProperty;

    public BasePropertyComponentAccessor() {
    }

    public BasePropertyComponentAccessor(String componentProperty) {
        this.componentProperty = componentProperty;
    }

    protected Class getType(Object object, String propertyName) throws Exception {
        String methodName = "get" + StringUtils.capitalize(propertyName);
        Method method = object.getClass().getMethod(methodName, null);
        return method.getReturnType();
    }

    protected Object invokeGetter(Object object, String propertyName) throws Exception {
        String methodName = "get" + StringUtils.capitalize(propertyName);
        Method method = object.getClass().getMethod(methodName, null);
        return method.invoke(object, (Object[])null);
    }

    protected void invokeSetter(Object object, String propertyName, Object value) throws Exception {
        String methodName = "set" + StringUtils.capitalize(propertyName);
        Method[] methods = object.getClass().getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            String candidateMethodName = methods[i].getName();
            if (!candidateMethodName.equals(methodName) || (parameterTypes = methods[i].getParameterTypes()) == null || parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(value.getClass())) continue;
            method = methods[i];
            break;
        }
        if (method == null) {
            throw new ComponentAccessorException("Could not find the setter method for property '" + propertyName + "' of object " + ObjectUtils.getObjectDescription(object));
        }
        method.invoke(object, value);
    }

    public String getComponentProperty() {
        if (this.componentProperty == null) {
            this.componentProperty = DEFAULT_COMPONENT_PROPERTY;
        }
        return this.componentProperty;
    }

    public void setComponentProperty(String componentProperty) {
        this.componentProperty = componentProperty;
    }
}

