/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.specialize.specializers;

import net.sf.composite.Defaults;
import net.sf.composite.extract.ComponentAccessor;
import net.sf.composite.specialize.SpecializationException;
import net.sf.composite.specialize.Specializer;
import net.sf.composite.util.Assert;
import net.sf.composite.util.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseSpecializer
implements Specializer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ComponentAccessor componentAccessor;

    protected abstract boolean isSpecializableImpl(Object var1, Class var2) throws Exception;

    private boolean isSpecializableInternal(Object composite, Class specializedType) {
        try {
            return this.isSpecializableImpl(composite, specializedType);
        }
        catch (SpecializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpecializationException("Unable to determine if composite " + ObjectUtils.getObjectDescription(composite) + " is specializable to type " + ObjectUtils.getObjectDescription(specializedType));
        }
    }

    public final boolean isSpecializable(Object composite, Class specializedType) throws SpecializationException {
        Assert.notNull(composite, "composite");
        boolean isSpecializable = this.isSpecializableInternal(composite, specializedType);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("composite " + ObjectUtils.getObjectDescription(composite) + (isSpecializable ? "is" : "is not") + " specializable to type " + ObjectUtils.getObjectDescription(specializedType)));
        }
        return isSpecializable;
    }

    protected abstract Object specializeImpl(Object var1, Class var2) throws Exception;

    public final Object specialize(Object composite, Class specializedType) throws SpecializationException {
        Assert.notNull(composite, "composite");
        try {
            if (!this.isSpecializableInternal(composite, specializedType)) {
                throw new SpecializationException("composite " + ObjectUtils.getObjectDescription(composite) + " is not specializable to type " + ObjectUtils.getObjectDescription(specializedType));
            }
            if (ObjectUtils.isEmpty(this.getComponentAccessor().getComponents(composite))) {
                throw new SpecializationException("Unable to specialize composite " + ObjectUtils.getObjectDescription(composite) + " because it contains no components of type " + ObjectUtils.getObjectDescription(specializedType));
            }
            Object specialized = this.specializeImpl(composite, specializedType);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Created specialized composite " + ObjectUtils.getObjectDescription(specialized) + " of type " + ObjectUtils.getObjectDescription(specializedType) + " from composite " + ObjectUtils.getObjectDescription(composite)));
            }
            return specialized;
        }
        catch (SpecializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpecializationException("Unable to specialize composite " + ObjectUtils.getObjectDescription(composite) + " to type " + ObjectUtils.getObjectDescription(specializedType), e);
        }
    }

    public synchronized ComponentAccessor getComponentAccessor() {
        if (this.componentAccessor == null) {
            this.setComponentAccessor(Defaults.createComponentAccessor());
        }
        return this.componentAccessor;
    }

    public synchronized void setComponentAccessor(ComponentAccessor componentExtractor) {
        this.componentAccessor = componentExtractor;
    }
}

