/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.specialize.specializers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.composite.specialize.Specializer;
import net.sf.composite.specialize.specializers.BaseSpecializer;
import net.sf.composite.util.ObjectPair;

public class CachingSpecializerProxy
extends BaseSpecializer {
    private Specializer specializer;
    private Map cache = Collections.synchronizedMap(new HashMap());

    public CachingSpecializerProxy() {
    }

    public CachingSpecializerProxy(Specializer specializer) {
        this.specializer = specializer;
    }

    protected boolean isSpecializableImpl(Object composite, Class specializedType) throws Exception {
        return this.specializer.isSpecializable(composite, specializedType);
    }

    protected Object specializeImpl(Object composite, Class specializedType) throws Exception {
        ObjectPair pair = new ObjectPair(composite, specializedType);
        Object result = this.cache.get(pair);
        if (result == null) {
            result = this.getSpecializer().specialize(composite, specializedType);
            this.cache.put(pair, result);
        }
        return result;
    }

    public Specializer getSpecializer() {
        return this.specializer;
    }

    public void setSpecializer(Specializer specializer) {
        this.specializer = specializer;
    }
}

