/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.specialize.specializers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import net.sf.composite.specialize.SpecializationException;
import net.sf.composite.specialize.Specializer;
import net.sf.composite.specialize.specializers.BaseSpecializer;
import net.sf.composite.util.ClassUtils;
import net.sf.composite.util.ContainerUtils;
import net.sf.composite.util.DelegatingInvocationHandler;
import net.sf.composite.util.ObjectUtils;

public class Jdk13ProxySpecializer
extends BaseSpecializer
implements Specializer {
    protected boolean isSpecializableImpl(Object composite, Class specializedType) throws Exception {
        if (!specializedType.isInterface()) {
            throw new SpecializationException(ObjectUtils.getObjectDescription(specializedType) + " must be an interface");
        }
        List components = this.getComponentAccessor().getComponents(composite);
        return specializedType.isAssignableFrom(composite.getClass()) || ContainerUtils.hasElementOfType(components, specializedType);
    }

    protected Object createNewComposite(Object composite) throws Exception {
        return composite.getClass().newInstance();
    }

    protected InvocationHandler createInvocationHandler(Object composite) throws Exception {
        return new DelegatingInvocationHandler(this.createNewComposite(composite));
    }

    protected Object specializeImpl(Object composite, Class specializedType) throws Exception {
        if (specializedType.isAssignableFrom(composite.getClass())) {
            return composite;
        }
        Class[] interfaces = ClassUtils.getInterfaces(composite.getClass());
        Class[] newInterfaces = new Class[interfaces.length + 1];
        System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
        newInterfaces[interfaces.length] = specializedType;
        Object newComposite = Proxy.newProxyInstance(specializedType.getClassLoader(), newInterfaces, this.createInvocationHandler(composite));
        List components = this.getComponentAccessor().getComponents(composite);
        List specializedComponents = ContainerUtils.getElementsOfType(components, specializedType);
        this.getComponentAccessor().setComponents(newComposite, specializedComponents);
        return newComposite;
    }
}

