/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    private int index = 0;
    private Object array;

    public ArrayIterator() {
    }

    public ArrayIterator(Object array) {
        this();
        this.setArray(array);
    }

    public boolean hasNext() {
        if (this.array == null) {
            return false;
        }
        return this.index < Array.getLength(this.array);
    }

    public Object next() {
        if (this.array == null) {
            throw new NoSuchElementException("The array was null, so there are no elements to iterate over");
        }
        if (this.index == Array.getLength(this.array)) {
            throw new NoSuchElementException("There are no more elements to iterate over");
        }
        return Array.get(this.array, this.index++);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object getArray() {
        return this.array;
    }

    public void setArray(Object array) {
        if (this.index != 0) {
            throw new IllegalStateException("Cannot change the array of an iterator that has already begun traversal");
        }
        if (array != null && !array.getClass().isArray()) {
            throw new IllegalArgumentException("The supplied array argument must be an array type, but '" + array.getClass().getName() + "' is not");
        }
        this.array = array;
    }
}

