/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassUtils {
    private static final Map classPresentCache = Collections.synchronizedMap(new HashMap());

    public static Class getContainedClass(Class arrayClass) {
        return arrayClass.getComponentType();
    }

    public static boolean isClassPresent(String className) {
        Boolean classPresent = (Boolean)classPresentCache.get(className);
        if (classPresent == null) {
            try {
                Class.forName(className);
                classPresent = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                classPresent = Boolean.FALSE;
            }
            classPresentCache.put(className, classPresent);
        }
        return classPresent;
    }

    public static boolean isJdk14OrHigherPresent() {
        return ClassUtils.isClassPresent("java.lang.CharSequence");
    }

    public static Object createArray(Class componentType, int length) {
        return Array.newInstance(componentType, length);
    }

    public static String getUnqualifiedClassName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    public static Class[] getInterfaces(Class clazz) {
        ArrayList result = new ArrayList();
        for (Class currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] currentInterfaces = currentClass.getInterfaces();
            for (int i = 0; i < currentInterfaces.length; ++i) {
                int idx = result.indexOf(currentInterfaces[i]);
                if (idx >= 0) {
                    if (idx == i) continue;
                    result.remove(idx);
                }
                result.add(i, currentInterfaces[i]);
            }
        }
        return result.toArray(new Class[result.size()]);
    }
}

