/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.util.List;
import net.sf.composite.Defaults;
import net.sf.composite.SpecializableComposite;
import net.sf.composite.extract.ComponentAccessor;
import net.sf.composite.specialize.SpecializationException;
import net.sf.composite.util.Assert;
import net.sf.composite.util.ClassUtils;
import net.sf.composite.util.ObjectUtils;
import net.sf.composite.util.StringUtils;

public abstract class CompositeUtils {
    private static final ComponentAccessor COMPONENT_ACCESSOR = Defaults.createComponentAccessor();

    private CompositeUtils() {
    }

    public static boolean isSpecializable(Object composite, Class type) {
        Assert.notEmpty(composite, "composite");
        Assert.notEmpty(composite, "type");
        return composite instanceof SpecializableComposite ? ((SpecializableComposite)composite).isSpecializable(type) : type.isAssignableFrom(composite.getClass());
    }

    public static Object specialize(Object composite, Class type) {
        Assert.notEmpty(composite, "composite");
        Assert.notEmpty(composite, "type");
        if (composite instanceof SpecializableComposite) {
            return ((SpecializableComposite)composite).specialize(type);
        }
        if (type.isAssignableFrom(composite.getClass())) {
            return composite;
        }
        throw new SpecializationException("The object " + ObjectUtils.getObjectDescription(composite) + " is not an instance of " + ObjectUtils.getObjectDescription(type) + " and cannot be specialized to that type because the" + " object is not a specializable composite");
    }

    public static String toString(Object composite) {
        if (composite == null) {
            return null;
        }
        String componentStr = "";
        List components = COMPONENT_ACCESSOR.getComponents(composite);
        if (!ObjectUtils.isEmpty(components)) {
            String[] classNames = new String[components.size()];
            for (int i = 0; i < classNames.length; ++i) {
                classNames[i] = ClassUtils.getUnqualifiedClassName(components.get(i).getClass());
            }
            componentStr = "[" + StringUtils.join(classNames, ",") + "]";
        }
        return ClassUtils.getUnqualifiedClassName(composite.getClass()) + componentStr;
    }
}

