/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.composite.util.ArrayIterator;
import net.sf.composite.util.Assert;
import net.sf.composite.util.ClassUtils;
import net.sf.composite.util.ObjectUtils;

public class ContainerUtils {
    public static Object[] getElementsOfType(Object[] array, Class type) {
        Assert.notEmpty(type, "type");
        if (array == null) {
            return null;
        }
        List list = ContainerUtils.getElementsOfType(Arrays.asList(array), type);
        Object[] toReturn = (Object[])ClassUtils.createArray(type, list.size());
        return list.toArray(toReturn);
    }

    public static List getElementsOfType(Collection collection, Class type) {
        Assert.notEmpty(type, "type");
        if (collection == null) {
            return null;
        }
        ArrayList elementsOfType = new ArrayList();
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (element == null || !type.isAssignableFrom(element.getClass())) continue;
            elementsOfType.add(element);
        }
        return elementsOfType;
    }

    public static boolean hasElementOfType(Object container, Class type) {
        Assert.notEmpty(container, "container");
        Assert.notEmpty(type, "type");
        Iterator iterator = ContainerUtils.getIterator(container);
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element == null || !type.isAssignableFrom(element.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Iterator getIterator(Object container) {
        if (container == null) {
            return null;
        }
        if (container instanceof Collection) {
            return ((Collection)container).iterator();
        }
        if (container.getClass().isArray()) {
            return new ArrayIterator(container);
        }
        throw new IllegalArgumentException("Could not construct an iterator for " + ObjectUtils.getObjectDescription(container));
    }
}

