/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DelegatingInvocationHandler
implements InvocationHandler {
    private Object delegate;

    public DelegatingInvocationHandler(Object delegate) {
        this.setDelegate(delegate);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object delegateToUse = this.getDelegate(proxy, method, args);
            Method delegateMethod = this.getDelegateMethod(delegateToUse, method, args);
            return delegateMethod.invoke(delegateToUse, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected Method getDelegateMethod(Object delegate, Method method, Object[] args) throws Exception {
        return delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    protected Object getDelegate(Object proxy, Method method, Object[] args) {
        return this.getDelegate();
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }
}

