/*
 * Decompiled with CFR 0.152.
 */
package net.sf.composite.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import net.sf.composite.util.ClassUtils;

public abstract class NestableRuntimeException
extends RuntimeException {
    private static final String NESTING_MESSAGE = "Nested Exception: ";
    private Throwable cause;

    public NestableRuntimeException() {
    }

    public NestableRuntimeException(String message) {
        super(message);
    }

    public NestableRuntimeException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public NestableRuntimeException(Throwable cause) {
        this.cause = cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void getMessage(StringBuffer sb) {
        sb.append(super.getMessage());
        sb.append("\n");
        if (this.cause != null) {
            sb.append(NESTING_MESSAGE);
            if (this.cause instanceof NestableRuntimeException) {
                NestableRuntimeException chainedCause = (NestableRuntimeException)this.cause;
                chainedCause.getMessage(sb);
            } else {
                sb.append(this.cause.getMessage());
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        Throwable t;
        super.printStackTrace(out);
        if (!ClassUtils.isJdk14OrHigherPresent() && (t = this.getCause()) != null) {
            out.println(NESTING_MESSAGE);
            t.printStackTrace(out);
        }
    }

    public void printStackTrace(PrintWriter out) {
        Throwable t;
        super.printStackTrace(out);
        if (!ClassUtils.isJdk14OrHigherPresent() && (t = this.getCause()) != null) {
            out.println(NESTING_MESSAGE);
            t.printStackTrace(out);
        }
    }
}

